/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.IProtocolConfigCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class JdbcConfigCli
implements IProtocolConfigCli {
    public static final int DEFAULT_TIMEOUT = 30;
    @CommandLine.Option(names={"--jdbc"}, order=1, description={"Enables JDBC"})
    private boolean useJdbc;
    @CommandLine.Option(names={"--jdbc-url"}, order=2, paramLabel="URL", description={"JDBC URL"})
    private char[] url;
    @CommandLine.Option(names={"--jdbc-username"}, order=3, paramLabel="USERNAME", description={"Username for JDBC authentication"})
    private String username;
    @CommandLine.Option(names={"--jdbc-password"}, order=4, paramLabel="PASSWORD", description={"Password for JDBC authentication"})
    private char[] password;
    @CommandLine.Option(names={"--jdbc-timeout"}, order=5, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for SQL queries(default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--jdbc-port"}, order=6, paramLabel="PORT", description={"Port for JDBC connection"})
    private int port;
    @CommandLine.Option(names={"--jdbc-database"}, order=7, paramLabel="DATABASE", description={"Name of the database"})
    private String database;
    @CommandLine.Option(names={"--jdbc-type"}, order=8, paramLabel="TYPE", description={"Type of JDBC database (e.g., MySQL, PostgreSQL, SQLServer)"})
    private String type;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        if (this.url != null && this.url.length > 0) {
            configuration.set("url", new TextNode(String.valueOf(this.url)));
        }
        configuration.set("timeout", new TextNode(this.timeout));
        configuration.set("port", new IntNode(this.port));
        configuration.set("database", new TextNode(this.database));
        configuration.set("type", new TextNode(this.type));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("jdbc", configuration, value -> value).orElseThrow();
    }

    @Generated
    public JdbcConfigCli() {
    }

    @Generated
    public boolean isUseJdbc() {
        return this.useJdbc;
    }

    @Generated
    public char[] getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setUseJdbc(boolean useJdbc) {
        this.useJdbc = useJdbc;
    }

    @Generated
    public void setUrl(char[] url) {
        this.url = url;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcConfigCli)) {
            return false;
        }
        JdbcConfigCli other = (JdbcConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseJdbc() != other.isUseJdbc()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (!Arrays.equals(this.getUrl(), other.getUrl())) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdbcConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseJdbc() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + Arrays.hashCode(this.getUrl());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdbcConfigCli(useJdbc=" + this.isUseJdbc() + ", url=" + Arrays.toString(this.getUrl()) + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", timeout=" + this.getTimeout() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", type=" + this.getType() + ")";
    }
}

