/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.IProtocolConfigCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class SnmpConfigCli
implements IProtocolConfigCli {
    public static final int DEFAULT_TIMEOUT = 30;
    @CommandLine.Option(names={"--snmp"}, order=1, defaultValue="1", paramLabel="VERSION", description={"Enables SNMP protocol version: 1 or 2"})
    String snmpVersion;
    @CommandLine.Option(names={"--snmp-community", "--community"}, order=2, paramLabel="COMMUNITY", defaultValue="public", description={"Community string for SNMP version 1 and 2 (default: ${DEFAULT-VALUE})"})
    char[] community;
    @CommandLine.Option(names={"--snmp-port"}, order=3, paramLabel="PORT", defaultValue="161", description={"Port of the SNMP agent (default: ${DEFAULT-VALUE})"})
    int port;
    @CommandLine.Option(names={"--snmp-timeout"}, order=4, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for SNMP operations (default: ${DEFAULT-VALUE} s)"})
    String timeout;
    @CommandLine.Option(names={"--snmp-retry-intervals", "--retry"}, order=5, paramLabel="RETRYINTERVALS", description={"Timeout in milliseconds after which the elementary operations will be retried"})
    int[] retryIntervals;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        configuration.set("version", new TextNode(this.snmpVersion));
        if (this.community != null) {
            configuration.set("community", new TextNode(String.valueOf(this.community)));
        }
        configuration.set("port", new IntNode(this.port));
        configuration.set("timeout", new TextNode(this.timeout));
        if (this.retryIntervals != null) {
            ArrayNode retryIntervalsArrayNode = configuration.putArray("retryIntervals");
            Arrays.stream(this.retryIntervals).forEach(retryIntervalsArrayNode::add);
        }
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("snmp", configuration, value -> value).orElseThrow();
    }

    @Generated
    public SnmpConfigCli() {
    }

    @Generated
    public String getSnmpVersion() {
        return this.snmpVersion;
    }

    @Generated
    public char[] getCommunity() {
        return this.community;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    @Generated
    public void setSnmpVersion(String snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    @Generated
    public void setCommunity(char[] community) {
        this.community = community;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpConfigCli)) {
            return false;
        }
        SnmpConfigCli other = (SnmpConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$snmpVersion = this.getSnmpVersion();
        String other$snmpVersion = other.getSnmpVersion();
        if (this$snmpVersion == null ? other$snmpVersion != null : !this$snmpVersion.equals(other$snmpVersion)) {
            return false;
        }
        if (!Arrays.equals(this.getCommunity(), other.getCommunity())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        return Arrays.equals(this.getRetryIntervals(), other.getRetryIntervals());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $snmpVersion = this.getSnmpVersion();
        result = result * 59 + ($snmpVersion == null ? 43 : $snmpVersion.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCommunity());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRetryIntervals());
        return result;
    }

    @Generated
    public String toString() {
        return "SnmpConfigCli(snmpVersion=" + this.getSnmpVersion() + ", community=" + Arrays.toString(this.getCommunity()) + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ", retryIntervals=" + Arrays.toString(this.getRetryIntervals()) + ")";
    }
}

