/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.IProtocolConfigCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class SnmpV3ConfigCli
implements IProtocolConfigCli {
    public static final int DEFAULT_TIMEOUT = 30;
    @CommandLine.Option(names={"--snmpv3"}, order=1, description={"Enable SNMP version 3 protocol"})
    private boolean useSnmpv3;
    @CommandLine.Option(names={"--snmpv3-privacy"}, order=2, paramLabel="DES|AES", description={"Privacy (encryption type) for SNMP version 3 (DES, AES, or none)"})
    private String privacy;
    @CommandLine.Option(names={"--snmpv3-privacy-password"}, order=3, paramLabel="PRIVACY-PASSWORD", description={"Privacy (encryption) password for SNMP version 3"})
    private char[] privacyPassword;
    @CommandLine.Option(names={"--snmpv3-auth"}, order=4, paramLabel="SHA|MD5", description={"Authentication type for SNMP version 3 (SHA, MD5 or NO_AUTH)"})
    private String authType;
    @CommandLine.Option(names={"--snmpv3-username"}, order=5, paramLabel="USERNAME", description={"Username for SNMP version 3 with MD5 or SHA"})
    private String username;
    @CommandLine.Option(names={"--snmpv3-password"}, order=6, paramLabel="PASSWORD", description={"Password for SNMP version 3 with MD5 or SHA"})
    private char[] password;
    @CommandLine.Option(names={"--snmpv3-context-name"}, order=7, paramLabel="CONTEXT-NAME", description={"Context name for SNMP version 3"})
    private String contextName;
    @CommandLine.Option(names={"--snmpv3-timeout"}, order=8, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for SNMP version 3 operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--snmpv3-port"}, order=9, paramLabel="PORT", defaultValue="161", description={"Port of the SNMP version 3 agent (default: ${DEFAULT-VALUE})"})
    private int port;
    @CommandLine.Option(names={"--snmpv3-retryIntervals"}, order=10, paramLabel="RETRY INTERVALS", split=",", description={"Comma-separated retry intervals in milliseconds for SNMP version 3 operations"})
    private int[] retryIntervals;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("privacy", new TextNode(this.privacy));
        if (this.privacyPassword != null) {
            configuration.set("privacyPassword", new TextNode(String.valueOf(this.privacyPassword)));
        }
        configuration.set("authType", new TextNode(this.authType));
        configuration.set("contextName", new TextNode(this.contextName));
        configuration.set("timeout", new TextNode(this.timeout));
        configuration.set("port", new IntNode(this.port));
        if (this.retryIntervals != null) {
            ArrayNode retryIntervalsNode = JsonNodeFactory.instance.arrayNode();
            Arrays.stream(this.retryIntervals).mapToObj(IntNode::valueOf).forEach(retryIntervalsNode::add);
            configuration.set("retryIntervals", retryIntervalsNode);
        }
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("snmpv3", configuration, value -> value).orElseThrow();
    }

    @Generated
    public SnmpV3ConfigCli() {
    }

    @Generated
    public boolean isUseSnmpv3() {
        return this.useSnmpv3;
    }

    @Generated
    public String getPrivacy() {
        return this.privacy;
    }

    @Generated
    public char[] getPrivacyPassword() {
        return this.privacyPassword;
    }

    @Generated
    public String getAuthType() {
        return this.authType;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getContextName() {
        return this.contextName;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int[] getRetryIntervals() {
        return this.retryIntervals;
    }

    @Generated
    public void setUseSnmpv3(boolean useSnmpv3) {
        this.useSnmpv3 = useSnmpv3;
    }

    @Generated
    public void setPrivacy(String privacy) {
        this.privacy = privacy;
    }

    @Generated
    public void setPrivacyPassword(char[] privacyPassword) {
        this.privacyPassword = privacyPassword;
    }

    @Generated
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setRetryIntervals(int[] retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpV3ConfigCli)) {
            return false;
        }
        SnmpV3ConfigCli other = (SnmpV3ConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSnmpv3() != other.isUseSnmpv3()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$privacy = this.getPrivacy();
        String other$privacy = other.getPrivacy();
        if (this$privacy == null ? other$privacy != null : !this$privacy.equals(other$privacy)) {
            return false;
        }
        if (!Arrays.equals(this.getPrivacyPassword(), other.getPrivacyPassword())) {
            return false;
        }
        String this$authType = this.getAuthType();
        String other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$contextName = this.getContextName();
        String other$contextName = other.getContextName();
        if (this$contextName == null ? other$contextName != null : !this$contextName.equals(other$contextName)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        return Arrays.equals(this.getRetryIntervals(), other.getRetryIntervals());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpV3ConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSnmpv3() ? 79 : 97);
        result = result * 59 + this.getPort();
        String $privacy = this.getPrivacy();
        result = result * 59 + ($privacy == null ? 43 : $privacy.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPrivacyPassword());
        String $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $contextName = this.getContextName();
        result = result * 59 + ($contextName == null ? 43 : $contextName.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRetryIntervals());
        return result;
    }

    @Generated
    public String toString() {
        return "SnmpV3ConfigCli(useSnmpv3=" + this.isUseSnmpv3() + ", privacy=" + this.getPrivacy() + ", privacyPassword=" + Arrays.toString(this.getPrivacyPassword()) + ", authType=" + this.getAuthType() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", contextName=" + this.getContextName() + ", timeout=" + this.getTimeout() + ", port=" + this.getPort() + ", retryIntervals=" + Arrays.toString(this.getRetryIntervals()) + ")";
    }
}

