/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.IProtocolConfigCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class SshConfigCli
implements IProtocolConfigCli {
    public static final int DEFAULT_TIMEOUT = 30;
    public static final int DEFAULT_PORT = 22;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--ssh"}, order=1, description={"Enables SSH"})
    private boolean useSsh;
    @CommandLine.Option(names={"--ssh-username"}, order=2, paramLabel="USER", description={"Username for SSH authentication"})
    private String username;
    @CommandLine.Option(names={"--ssh-password"}, order=3, paramLabel="P4SSW0RD", description={"Password or SSH authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--ssh-privatekey"}, order=4, paramLabel="PATH", description={"Path to the private key file for SSH authentication"})
    private String privateKey;
    @CommandLine.Option(names={"--ssh-timeout"}, order=5, paramLabel="TIMEOUT", description={"Timeout in seconds for SSH operations (default: ${DEFAULT-VALUE} s)"}, defaultValue="30")
    private String timeout;
    @CommandLine.Option(names={"--ssh-port"}, order=6, paramLabel="PORT", defaultValue="22", description={"Port number for SSH connection (default: ${DEFAULT-VALUE})"})
    private Integer port;
    @CommandLine.Option(names={"--ssh-usesudo-commands"}, order=7, paramLabel="COMMAND", description={"List of commands that requires @|italic sudo|@"}, split=",")
    private Set<String> useSudoCommands;
    @CommandLine.Option(names={"--ssh-sudo-command"}, order=8, paramLabel="SUDO", description={"@|italic sudo|@ command (default: ${DEFAULT-VALUE})"}, defaultValue="sudo")
    private String sudoCommand;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        ArrayNode sudoCommands = JsonNodeFactory.instance.arrayNode();
        if (this.useSudoCommands != null) {
            this.useSudoCommands.stream().forEach(sudoCommands::add);
        }
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("privateKey", new TextNode(this.privateKey));
        configuration.set("useSudoCommands", sudoCommands);
        configuration.set("useSudo", BooleanNode.TRUE);
        configuration.set("sudoCommand", new TextNode(this.sudoCommand));
        configuration.set("timeout", new TextNode(this.timeout));
        configuration.set("port", new IntNode(this.getPort()));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("ssh", configuration, value -> value).orElseThrow();
    }

    public int getPort() {
        return this.port != null ? this.port : 22;
    }

    @Generated
    public SshConfigCli() {
    }

    @Generated
    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public boolean isUseSsh() {
        return this.useSsh;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public Set<String> getUseSudoCommands() {
        return this.useSudoCommands;
    }

    @Generated
    public String getSudoCommand() {
        return this.sudoCommand;
    }

    @Generated
    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    @Generated
    public void setUseSsh(boolean useSsh) {
        this.useSsh = useSsh;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setUseSudoCommands(Set<String> useSudoCommands) {
        this.useSudoCommands = useSudoCommands;
    }

    @Generated
    public void setSudoCommand(String sudoCommand) {
        this.sudoCommand = sudoCommand;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SshConfigCli)) {
            return false;
        }
        SshConfigCli other = (SshConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSsh() != other.isUseSsh()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        CommandLine.Model.CommandSpec this$spec = this.getSpec();
        CommandLine.Model.CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        Set<String> this$useSudoCommands = this.getUseSudoCommands();
        Set<String> other$useSudoCommands = other.getUseSudoCommands();
        if (this$useSudoCommands == null ? other$useSudoCommands != null : !((Object)this$useSudoCommands).equals(other$useSudoCommands)) {
            return false;
        }
        String this$sudoCommand = this.getSudoCommand();
        String other$sudoCommand = other.getSudoCommand();
        return !(this$sudoCommand == null ? other$sudoCommand != null : !this$sudoCommand.equals(other$sudoCommand));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SshConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSsh() ? 79 : 97);
        result = result * 59 + this.getPort();
        CommandLine.Model.CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        Set<String> $useSudoCommands = this.getUseSudoCommands();
        result = result * 59 + ($useSudoCommands == null ? 43 : ((Object)$useSudoCommands).hashCode());
        String $sudoCommand = this.getSudoCommand();
        result = result * 59 + ($sudoCommand == null ? 43 : $sudoCommand.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SshConfigCli(spec=" + String.valueOf(this.getSpec()) + ", useSsh=" + this.isUseSsh() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", privateKey=" + this.getPrivateKey() + ", timeout=" + this.getTimeout() + ", port=" + this.getPort() + ", useSudoCommands=" + String.valueOf(this.getUseSudoCommands()) + ", sudoCommand=" + this.getSudoCommand() + ")";
    }
}

