/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.AbstractTransportProtocolCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class WbemConfigCli
extends AbstractTransportProtocolCli {
    public static final int DEFAULT_TIMEOUT = 30;
    @CommandLine.Option(names={"--wbem"}, order=1, description={"Enables WBEM"})
    private boolean useWbem;
    @CommandLine.Option(names={"--wbem-transport"}, order=2, defaultValue="HTTPS", paramLabel="HTTP|HTTPS", description={"Transport protocol for WBEM (default: ${DEFAULT-VALUE})"})
    private String protocol;
    @CommandLine.Option(names={"--wbem-port"}, order=3, paramLabel="PORT", description={"Port of the WBEM server (default: 5988 for HTTP, 5989 for HTTPS)"})
    private Integer port;
    @CommandLine.Option(names={"--wbem-username"}, order=4, paramLabel="USER", description={"Username for WBEM authentication"})
    String username;
    @CommandLine.Option(names={"--wbem-password"}, order=5, paramLabel="P4SSW0RD", description={"Password for WBEM authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--wbem-timeout"}, order=6, defaultValue="30", paramLabel="TIMEOUT", description={"Timeout in seconds for WBEM operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--wbem-force-namespace"}, order=7, paramLabel="NAMESPACE", description={"Forces a specific namespace for connectors that perform namespace auto-detection (advanced)"})
    private String namespace;
    @CommandLine.Option(names={"--wbem-vcenter"}, order=8, paramLabel="VCENTER", description={"VCenter hostname providing the authentication ticket (if applicable)"})
    private String vcenter;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("timeout", new TextNode(this.timeout));
        configuration.set("namespace", new TextNode(this.namespace));
        configuration.set("vcenter", new TextNode(this.vcenter));
        configuration.set("protocol", new TextNode(this.protocol));
        configuration.set("port", new IntNode(this.getOrDeducePortNumber()));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("wbem", configuration, value -> value).orElseThrow();
    }

    @Override
    protected int defaultHttpsPortNumber() {
        return 5989;
    }

    @Override
    protected int defaultHttpPortNumber() {
        return 5988;
    }

    @Override
    protected boolean isHttps() {
        return "https".equalsIgnoreCase(this.protocol);
    }

    @Generated
    public WbemConfigCli() {
    }

    @Generated
    public boolean isUseWbem() {
        return this.useWbem;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getVcenter() {
        return this.vcenter;
    }

    @Generated
    public void setUseWbem(boolean useWbem) {
        this.useWbem = useWbem;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setVcenter(String vcenter) {
        this.vcenter = vcenter;
    }

    @Generated
    public String toString() {
        return "WbemConfigCli(useWbem=" + this.isUseWbem() + ", protocol=" + this.getProtocol() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", timeout=" + this.getTimeout() + ", namespace=" + this.getNamespace() + ", vcenter=" + this.getVcenter() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WbemConfigCli)) {
            return false;
        }
        WbemConfigCli other = (WbemConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUseWbem() != other.isUseWbem()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$vcenter = this.getVcenter();
        String other$vcenter = other.getVcenter();
        return !(this$vcenter == null ? other$vcenter != null : !this$vcenter.equals(other$vcenter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WbemConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUseWbem() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $vcenter = this.getVcenter();
        result = result * 59 + ($vcenter == null ? 43 : $vcenter.hashCode());
        return result;
    }
}

