/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.AbstractTransportProtocolCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class WinRmConfigCli
extends AbstractTransportProtocolCli {
    public static final int DEFAULT_TIMEOUT = 30;
    public static final Integer DEFAULT_HTTP_PORT = 5985;
    public static final Integer DEFAULT_HTTPS_PORT = 5986;
    @CommandLine.Option(names={"--winrm"}, order=1, description={"Enables WinRM"})
    private boolean useWinRM;
    @CommandLine.Option(names={"--winrm-transport"}, order=2, paramLabel="HTTP|HTTPS", defaultValue="HTTP", description={"Transport protocol for WinRM (default: ${DEFAULT-VALUE})"})
    private String protocol;
    @CommandLine.Option(names={"--winrm-username"}, order=3, paramLabel="USER", description={"Username for WinRM authentication"})
    private String username;
    @CommandLine.Option(names={"--winrm-password"}, order=4, paramLabel="P4SSW0RD", description={"Password for the WinRM authentication"}, arity="0..1", interactive=true)
    private char[] password;
    @CommandLine.Option(names={"--winrm-port"}, order=5, paramLabel="PORT", description={"Port for WinRM service (default: 5985 for HTTP, 5986 for HTTPS)"})
    private Integer port;
    @CommandLine.Option(names={"--winrm-timeout"}, order=6, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for WinRM operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--winrm-auth"}, description={"Comma-separated ordered list of authentication schemes. Possible values are NTLM and KERBEROS. By default, only NTLM is used"}, order=7, paramLabel="AUTH", split=",")
    private List<String> authentications;
    @CommandLine.Option(names={"--winrm-force-namespace"}, order=8, paramLabel="NAMESPACE", description={"Forces a specific namespace for connectors that perform namespace auto-detection (advanced)"})
    private String namespace;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        String finalUsername = this.username == null ? defaultUsername : this.username;
        char[] finalPassword = this.username == null ? defaultPassword : this.password;
        configuration.set("username", new TextNode(finalUsername));
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("namespace", new TextNode(this.namespace));
        configuration.set("port", new IntNode(this.getOrDeducePortNumber()));
        configuration.set("protocol", new TextNode(this.protocol));
        configuration.set("authentications", this.getAuthentications());
        configuration.set("timeout", new TextNode(this.timeout));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("winrm", configuration, value -> value).orElseThrow();
    }

    @Override
    protected int defaultHttpsPortNumber() {
        return 5986;
    }

    @Override
    protected int defaultHttpPortNumber() {
        return 5985;
    }

    protected ArrayNode getAuthentications() {
        ArrayNode authenticationsList = null;
        if (this.authentications != null) {
            authenticationsList = JsonNodeFactory.instance.arrayNode();
            this.authentications.stream().forEach(authenticationsList::add);
        }
        return authenticationsList;
    }

    @Override
    protected boolean isHttps() {
        return "https".equalsIgnoreCase(this.protocol);
    }

    @Generated
    public WinRmConfigCli() {
    }

    @Generated
    public boolean isUseWinRM() {
        return this.useWinRM;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public void setUseWinRM(boolean useWinRM) {
        this.useWinRM = useWinRM;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setAuthentications(List<String> authentications) {
        this.authentications = authentications;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public String toString() {
        return "WinRmConfigCli(useWinRM=" + this.isUseWinRM() + ", protocol=" + this.getProtocol() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ", authentications=" + String.valueOf(this.getAuthentications()) + ", namespace=" + this.getNamespace() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WinRmConfigCli)) {
            return false;
        }
        WinRmConfigCli other = (WinRmConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUseWinRM() != other.isUseWinRM()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        ArrayNode this$authentications = this.getAuthentications();
        ArrayNode other$authentications = other.getAuthentications();
        if (this$authentications == null ? other$authentications != null : !((Object)this$authentications).equals(other$authentications)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WinRmConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUseWinRM() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        ArrayNode $authentications = this.getAuthentications();
        result = result * 59 + ($authentications == null ? 43 : ((Object)$authentications).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }
}

