/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.cli.service.protocol;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import lombok.Generated;
import org.sentrysoftware.metricshub.cli.service.CliExtensionManager;
import org.sentrysoftware.metricshub.cli.service.protocol.IProtocolConfigCli;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import picocli.CommandLine;

public class WmiConfigCli
implements IProtocolConfigCli {
    public static final int DEFAULT_TIMEOUT = 30;
    @CommandLine.Option(names={"--wmi"}, order=1, description={"Enables WMI"})
    private boolean useWmi;
    @CommandLine.Option(names={"--wmi-username"}, order=2, paramLabel="USER", description={"Username for WMI authentication"})
    private String username;
    @CommandLine.Option(names={"--wmi-password"}, order=3, paramLabel="P4SSW0RD", description={"Password for WMI authentication"}, interactive=true, arity="0..1")
    private char[] password;
    @CommandLine.Option(names={"--wmi-timeout"}, order=4, paramLabel="TIMEOUT", defaultValue="30", description={"Timeout in seconds for WMI operations (default: ${DEFAULT-VALUE} s)"})
    private String timeout;
    @CommandLine.Option(names={"--wmi-force-namespace"}, order=5, paramLabel="NAMESPACE", description={"Force a specific namespace for connectors that perform namespace auto-detection (advanced)"})
    private String namespace;

    @Override
    public IConfiguration toConfiguration(String defaultUsername, char[] defaultPassword) throws InvalidConfigurationException {
        char[] finalPassword;
        ObjectNode configuration = JsonNodeFactory.instance.objectNode();
        String finalUsername = this.username == null ? defaultUsername : this.username;
        configuration.set("username", new TextNode(finalUsername));
        char[] cArray = finalPassword = this.username == null ? defaultPassword : this.password;
        if (finalPassword != null) {
            configuration.set("password", new TextNode(String.valueOf(finalPassword)));
        }
        configuration.set("timeout", new TextNode(this.timeout));
        configuration.set("namespace", new TextNode(this.namespace));
        return CliExtensionManager.getExtensionManagerSingleton().buildConfigurationFromJsonNode("wmi", configuration, value -> value).orElseThrow();
    }

    @Generated
    public WmiConfigCli() {
    }

    @Generated
    public boolean isUseWmi() {
        return this.useWmi;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public void setUseWmi(boolean useWmi) {
        this.useWmi = useWmi;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WmiConfigCli)) {
            return false;
        }
        WmiConfigCli other = (WmiConfigCli)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseWmi() != other.isUseWmi()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WmiConfigCli;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseWmi() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WmiConfigCli(useWmi=" + this.isUseWmi() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", timeout=" + this.getTimeout() + ", namespace=" + this.getNamespace() + ")";
    }
}

