/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;

public class FilterResultHelper {
    public static List<String> filterLines(@NonNull List<String> lines, Integer removeHeader, Integer removeFooter, String excludeRegExp, String keepOnlyRegExp) {
        if (lines == null) {
            throw new IllegalArgumentException("lines is marked non-null but is null");
        }
        int begin = removeHeader != null ? removeHeader : 0;
        int end = removeFooter != null ? lines.size() - removeFooter : lines.size();
        Pattern excludePattern = excludeRegExp == null || excludeRegExp.isEmpty() ? null : Pattern.compile(PslUtils.psl2JavaRegex(excludeRegExp));
        Pattern keepOnlyPattern = keepOnlyRegExp == null || keepOnlyRegExp.isEmpty() ? null : Pattern.compile(PslUtils.psl2JavaRegex(keepOnlyRegExp));
        return IntStream.range(begin, end).mapToObj(lines::get).filter(line -> !(excludePattern != null && excludePattern.matcher((CharSequence)line).find() || keepOnlyPattern != null && !keepOnlyPattern.matcher((CharSequence)line).find())).collect(Collectors.toList());
    }

    public static List<String> selectedColumns(@NonNull List<String> lines, String separators, String selectColumns) {
        if (lines == null) {
            throw new IllegalArgumentException("lines is marked non-null but is null");
        }
        if (separators == null || separators.isEmpty() || selectColumns == null || selectColumns.isBlank()) {
            return lines;
        }
        return lines.stream().map(line -> {
            if (!separators.contains(";") && !separators.contains(",")) {
                return line.replace(";", ",");
            }
            if (!separators.contains(";")) {
                return line.replace(";", "");
            }
            return line;
        }).map(line -> !separators.contains("\t") && !separators.contains(" ") ? PslUtils.nthArgf(line, selectColumns, separators, ";") : PslUtils.nthArg(line, selectColumns, separators, ";")).collect(Collectors.toList());
    }

    @Generated
    private FilterResultHelper() {
    }
}

