/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.InputStream;

public class JsonHelper {
    private JsonHelper() {
    }

    public static <T> String serialize(T value) {
        try {
            return JsonHelper.buildObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            return "{}";
        }
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws IOException {
        return JsonHelper.buildObjectMapper().readValue(json, clazz);
    }

    public static <T> T deserialize(ObjectMapper mapper, InputStream input, Class<T> type) throws IOException {
        return mapper.readValue(input, type);
    }

    public static <T> T deserialize(ObjectMapper mapper, TreeNode node, Class<T> type) throws IOException {
        return mapper.treeToValue(node, type);
    }

    public static <T> T deserialize(InputStream is, Class<T> clazz) throws IOException {
        return JsonHelper.buildObjectMapper().readValue(is, clazz);
    }

    public static ObjectMapper buildObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)).enable(SerializationFeature.INDENT_OUTPUT)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public static ObjectMapper buildYamlMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder(new YAMLFactory().disable(YAMLGenerator.Feature.SPLIT_LINES).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES)).build();
    }

    public static boolean isNotNull(JsonNode jsonNode) {
        return jsonNode != null && !jsonNode.isNull();
    }
}

