/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingHelper.class);

    public static void logSourceError(String connectorId, String sourceKey, String context, String hostname, Throwable throwable) {
        if (log.isErrorEnabled()) {
            log.error("Hostname {} - Source [{}] was unsuccessful due to an exception. Context [{}]. Connector: [{}]. Returning an empty table. Errors:\n{}\n", hostname, sourceKey, context, connectorId, StringHelper.getStackMessages(throwable));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Hostname %s - Source [%s] was unsuccessful due to an exception. Context [%s]. Connector: [%s]. Returning an empty table. Stack trace:", hostname, sourceKey, context, connectorId), throwable);
        }
    }

    public static void trace(Runnable runnable2) {
        if (log.isTraceEnabled()) {
            runnable2.run();
        }
    }

    public static void debug(Runnable runnable2) {
        if (log.isDebugEnabled()) {
            runnable2.run();
        }
    }

    @Generated
    private LoggingHelper() {
    }
}

