/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;

public class CustomDeserializer
extends DelegatingDeserializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\s*(\\$\\{source::((monitors)\\.(.*)\\.(.*)\\.sources\\.(.*))|((beforeAll|afterAll)\\.(.*))\\})\\s*", 10);
    private static final long serialVersionUID = 1L;

    public CustomDeserializer(JsonDeserializer<?> delegate) {
        super(delegate);
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new CustomDeserializer(newDelegatee);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object deserializedObject = super.deserialize(p, ctxt);
        this.callPostDeserialize(deserializedObject);
        return deserializedObject;
    }

    private void callPostDeserialize(Object deserializedObject) {
        if (deserializedObject instanceof Source) {
            Source source2 = (Source)deserializedObject;
            String sourceKey = source2.getKey();
            source2.setKey(null);
            HashSet<String> refs = new HashSet<String>();
            this.references(OBJECT_MAPPER.convertValue(deserializedObject, JsonNode.class), refs, val2 -> REFERENCE_PATTERN.matcher((CharSequence)val2).find());
            source2.setKey(sourceKey);
            source2.setReferences(refs);
        }
    }

    private void references(JsonNode jsonNode, Collection<String> refs, Predicate<String> predicate) {
        String value;
        if (jsonNode == null) {
            return;
        }
        if (jsonNode.isObject()) {
            jsonNode.fields().forEachRemaining(entry -> this.references((JsonNode)entry.getValue(), refs, predicate));
        } else if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                this.references(jsonNode.get(i), refs, predicate);
            }
        } else if (!jsonNode.isNull() && predicate.test(value = jsonNode.asText())) {
            refs.add(value);
        }
    }
}

