/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.parser.ConnectorLibraryParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorStore
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorStore.class);
    private static final long serialVersionUID = 1L;
    private Map<String, Connector> store;
    private transient Path connectorDirectory;

    public ConnectorStore(Path connectorDirectory) {
        try {
            this.connectorDirectory = connectorDirectory;
            this.store = this.deserializeConnectors();
        }
        catch (Exception e) {
            log.error("Error while deserializing connectors. The ConnectorStore is empty!");
            log.debug("Error while deserializing connectors. The ConnectorStore is empty!", e);
            this.store = new HashMap<String, Connector>();
        }
    }

    private Map<String, Connector> deserializeConnectors() throws IOException {
        ConnectorLibraryParser connectorLibraryParser = new ConnectorLibraryParser();
        return connectorLibraryParser.parseConnectorsFromAllYamlFiles(this.connectorDirectory);
    }

    public void addOne(@NonNull String id, @NonNull Connector connector) {
        if (id == null) {
            throw new IllegalArgumentException("id is marked non-null but is null");
        }
        if (connector == null) {
            throw new IllegalArgumentException("connector is marked non-null but is null");
        }
        this.store.put(id, connector);
    }

    public void addMany(@NonNull Map<String, Connector> connectors) {
        if (connectors == null) {
            throw new IllegalArgumentException("connectors is marked non-null but is null");
        }
        this.store.putAll(connectors);
    }

    public ConnectorStore newConnectorStore() {
        ConnectorStore newConnectorStore = new ConnectorStore();
        TreeMap<String, Connector> originalConnectors = new TreeMap<String, Connector>(String.CASE_INSENSITIVE_ORDER);
        originalConnectors.putAll(this.store);
        newConnectorStore.setStore(originalConnectors);
        return newConnectorStore;
    }

    @Generated
    public ConnectorStore() {
    }

    @Generated
    public Map<String, Connector> getStore() {
        return this.store;
    }

    @Generated
    public void setStore(Map<String, Connector> store) {
        this.store = store;
    }

    @Generated
    public void setConnectorDirectory(Path connectorDirectory) {
        this.connectorDirectory = connectorDirectory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorStore)) {
            return false;
        }
        ConnectorStore other = (ConnectorStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Connector> this$store = this.getStore();
        Map<String, Connector> other$store = other.getStore();
        return !(this$store == null ? other$store != null : !((Object)this$store).equals(other$store));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Connector> $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : ((Object)$store).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConnectorStore(store=" + String.valueOf(this.getStore()) + ", connectorDirectory=" + String.valueOf(this.getConnectorDirectory()) + ")";
    }

    @Generated
    public Path getConnectorDirectory() {
        return this.connectorDirectory;
    }
}

