/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.common;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;

public enum DeviceKind {
    VMS("HP Open VMS"),
    TRU64("HP Tru64"),
    HPUX("HP-UX"),
    AIX("IBM AIX"),
    LINUX("Linux"),
    OOB("Management"),
    WINDOWS("Microsoft Windows"),
    NETWORK("Network"),
    STORAGE("Storage"),
    SOLARIS("Oracle Solaris"),
    OTHER("Other");

    private String displayName;
    public static final Set<DeviceKind> DEVICE_KINDS;
    private static final Map<DeviceKind, Pattern> DETECTORS;

    public static DeviceKind detect(String value) {
        if (value == null) {
            return null;
        }
        String lCaseValue = value.trim().toLowerCase();
        for (Map.Entry<DeviceKind, Pattern> detector : DETECTORS.entrySet()) {
            if (!detector.getValue().matcher(lCaseValue).find()) continue;
            return detector.getKey();
        }
        throw new IllegalArgumentException("'" + value + "' is not a supported device kind.");
    }

    @Generated
    private DeviceKind(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    static {
        DEVICE_KINDS = Set.of(DeviceKind.values());
        DETECTORS = Map.ofEntries(new AbstractMap.SimpleEntry<DeviceKind, Pattern>(LINUX, Pattern.compile("^lin$|^linux$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(WINDOWS, Pattern.compile("^(microsoft\\s*)?windows$|^win$|^nt$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(OOB, Pattern.compile("^management$|^mgmt$|^management\\s*card$|^out-of-band$|^out\\s*of\\s*band$|^oob$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(NETWORK, Pattern.compile("^network$|^switch$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(STORAGE, Pattern.compile("^storage$|^san$|^library$|^array$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(VMS, Pattern.compile("^vms$|^(hp\\s*)?open\\s*vms$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(TRU64, Pattern.compile("^tru64$|^osf1$|^hp\\s*tru64\\s*unix$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(HPUX, Pattern.compile("^hp-ux$|^hpux$|^hp$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(AIX, Pattern.compile("^ibm(\\s*|-)aix$|^aix$|^rs6000$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(SOLARIS, Pattern.compile("^((sun|oracle)\\s*)?solaris$|^sunos$")), new AbstractMap.SimpleEntry<DeviceKind, Pattern>(OTHER, Pattern.compile("^other$")));
    }
}

