/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.common;

import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;

public enum ResultContent {
    HTTP_STATUS("httpStatus"),
    HEADER("header"),
    BODY("body"),
    ALL("all"),
    ALL_WITH_STATUS("all_with_status");

    private static final Map<ResultContent, Pattern> DETECTORS;
    private String name;

    public static ResultContent detect(String value) {
        if (value == null) {
            return null;
        }
        String lCaseValue = value.trim().toLowerCase();
        for (Map.Entry<ResultContent, Pattern> detector : DETECTORS.entrySet()) {
            if (!detector.getValue().matcher(lCaseValue).find()) continue;
            return detector.getKey();
        }
        throw new IllegalArgumentException("'" + value + "' is not a supported ResultContent. Accepted values are: [ httpStatus, header, body, all ].");
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private ResultContent(String name) {
        this.name = name;
    }

    static {
        DETECTORS = Map.of(HTTP_STATUS, Pattern.compile("^httpstatus$|^http_status$"), HEADER, Pattern.compile("^header$"), BODY, Pattern.compile("^body$"), ALL, Pattern.compile("^all$"), ALL_WITH_STATUS, Pattern.compile("^all_with_status$"));
    }
}

