/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.common;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.SqlColumn;

public class SqlTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private String source;
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private String alias;
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private List<SqlColumn> columns;

    public SqlTable copy() {
        return SqlTable.builder().source(this.source).alias(this.alias).columns(this.columns.stream().map(SqlColumn::copy).collect(Collectors.toCollection(ArrayList::new))).build();
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        StringHelper.addNonNull(stringJoiner, "Source ", this.source);
        StringHelper.addNonNull(stringJoiner, " AS ", this.alias);
        if (this.columns != null && !this.columns.isEmpty()) {
            stringJoiner.add(" Columns:");
            this.columns.stream().forEach(column -> stringJoiner.add(" - " + column.toString()));
        }
        return stringJoiner.toString();
    }

    @Generated
    public static SqlTableBuilder builder() {
        return new SqlTableBuilder();
    }

    @NonNull
    @Generated
    public String getSource() {
        return this.source;
    }

    @NonNull
    @Generated
    public String getAlias() {
        return this.alias;
    }

    @NonNull
    @Generated
    public List<SqlColumn> getColumns() {
        return this.columns;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setSource(@NonNull String source2) {
        if (source2 == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        this.source = source2;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setAlias(@NonNull String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        this.alias = alias;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setColumns(@NonNull List<SqlColumn> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns is marked non-null but is null");
        }
        this.columns = columns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlTable)) {
            return false;
        }
        SqlTable other = (SqlTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        List<SqlColumn> this$columns = this.getColumns();
        List<SqlColumn> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        List<SqlColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    @Generated
    public SqlTable(@NonNull String source2, @NonNull String alias, @NonNull List<SqlColumn> columns) {
        if (source2 == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        if (alias == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (columns == null) {
            throw new IllegalArgumentException("columns is marked non-null but is null");
        }
        this.source = source2;
        this.alias = alias;
        this.columns = columns;
    }

    @Generated
    public SqlTable() {
    }

    @Generated
    public static class SqlTableBuilder {
        @Generated
        private String source;
        @Generated
        private String alias;
        @Generated
        private List<SqlColumn> columns;

        @Generated
        SqlTableBuilder() {
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @Generated
        public SqlTableBuilder source(@NonNull String source2) {
            if (source2 == null) {
                throw new IllegalArgumentException("source is marked non-null but is null");
            }
            this.source = source2;
            return this;
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @Generated
        public SqlTableBuilder alias(@NonNull String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("alias is marked non-null but is null");
            }
            this.alias = alias;
            return this;
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @Generated
        public SqlTableBuilder columns(@NonNull List<SqlColumn> columns) {
            if (columns == null) {
                throw new IllegalArgumentException("columns is marked non-null but is null");
            }
            this.columns = columns;
            return this;
        }

        @Generated
        public SqlTable build() {
            return new SqlTable(this.source, this.alias, this.columns);
        }

        @Generated
        public String toString() {
            return "SqlTable.SqlTableBuilder(source=" + this.source + ", alias=" + this.alias + ", columns=" + String.valueOf(this.columns) + ")";
        }
    }
}

