/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.BooleanDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.PositiveIntegerDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.TimeoutDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class CommandLineSource
extends Source {
    private static final String WHITE_SPACE_TAB = " \t";
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String commandLine;
    @JsonDeserialize(using=TimeoutDeserializer.class)
    private Long timeout;
    @JsonDeserialize(using=BooleanDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean executeLocally = false;
    private String exclude;
    private String keep;
    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    private Integer beginAtLineNumber;
    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    private Integer endAtLineNumber;
    private String separators = " \t";
    private String selectColumns;

    @JsonCreator
    public CommandLineSource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="commandLine", required=true) @NonNull String commandLine, @JsonProperty(value="timeout") Long timeout2, @JsonProperty(value="executeLocally") Boolean executeLocally, @JsonProperty(value="exclude") String exclude, @JsonProperty(value="keep") String keep, @JsonProperty(value="beginAtLineNumber") Integer beginAtLineNumber, @JsonProperty(value="endAtLineNumber") Integer endAtLineNumber, @JsonProperty(value="separators") String separators, @JsonProperty(value="selectColumns") String selectColumns, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        this.commandLine = commandLine;
        this.timeout = timeout2;
        this.executeLocally = executeLocally != null && executeLocally != false;
        this.exclude = exclude;
        this.keep = keep;
        this.beginAtLineNumber = beginAtLineNumber;
        this.endAtLineNumber = endAtLineNumber;
        this.separators = separators == null ? WHITE_SPACE_TAB : separators;
        this.selectColumns = selectColumns;
    }

    @Override
    public CommandLineSource copy() {
        return CommandLineSource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).commandLine(this.commandLine).executeLocally(this.executeLocally).exclude(this.exclude).keep(this.keep).beginAtLineNumber(this.beginAtLineNumber).endAtLineNumber(this.endAtLineNumber).selectColumns(this.selectColumns).separators(this.separators).timeout(this.timeout).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.commandLine = (String)updater.apply(this.commandLine);
        this.exclude = (String)updater.apply(this.exclude);
        this.keep = (String)updater.apply(this.keep);
        this.separators = (String)updater.apply(this.separators);
        this.selectColumns = (String)updater.apply(this.selectColumns);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- commandLine=", this.commandLine);
        StringHelper.addNonNull(stringJoiner, "- timeout=", this.timeout);
        StringHelper.addNonNull(stringJoiner, "- executeLocally=", this.executeLocally);
        StringHelper.addNonNull(stringJoiner, "- exclude=", this.exclude);
        StringHelper.addNonNull(stringJoiner, "- keep=", this.keep);
        StringHelper.addNonNull(stringJoiner, "- beginAtLineNumber=", this.beginAtLineNumber);
        StringHelper.addNonNull(stringJoiner, "- endAtLineNumber=", this.endAtLineNumber);
        StringHelper.addNonNull(stringJoiner, "- separators=", this.separators);
        StringHelper.addNonNull(stringJoiner, "- selectColumns=", this.selectColumns);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static CommandLineSourceBuilder builder() {
        return new CommandLineSourceBuilder();
    }

    @NonNull
    @Generated
    public String getCommandLine() {
        return this.commandLine;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public Boolean getExecuteLocally() {
        return this.executeLocally;
    }

    @Generated
    public String getExclude() {
        return this.exclude;
    }

    @Generated
    public String getKeep() {
        return this.keep;
    }

    @Generated
    public Integer getBeginAtLineNumber() {
        return this.beginAtLineNumber;
    }

    @Generated
    public Integer getEndAtLineNumber() {
        return this.endAtLineNumber;
    }

    @Generated
    public String getSeparators() {
        return this.separators;
    }

    @Generated
    public String getSelectColumns() {
        return this.selectColumns;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setCommandLine(@NonNull String commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        this.commandLine = commandLine;
    }

    @JsonDeserialize(using=TimeoutDeserializer.class)
    @Generated
    public void setTimeout(Long timeout2) {
        this.timeout = timeout2;
    }

    @JsonDeserialize(using=BooleanDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setExecuteLocally(Boolean executeLocally) {
        this.executeLocally = executeLocally;
    }

    @Generated
    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    @Generated
    public void setKeep(String keep) {
        this.keep = keep;
    }

    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    @Generated
    public void setBeginAtLineNumber(Integer beginAtLineNumber) {
        this.beginAtLineNumber = beginAtLineNumber;
    }

    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    @Generated
    public void setEndAtLineNumber(Integer endAtLineNumber) {
        this.endAtLineNumber = endAtLineNumber;
    }

    @Generated
    public void setSeparators(String separators) {
        this.separators = separators;
    }

    @Generated
    public void setSelectColumns(String selectColumns) {
        this.selectColumns = selectColumns;
    }

    @Generated
    public CommandLineSource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandLineSource)) {
            return false;
        }
        CommandLineSource other = (CommandLineSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Boolean this$executeLocally = this.getExecuteLocally();
        Boolean other$executeLocally = other.getExecuteLocally();
        if (this$executeLocally == null ? other$executeLocally != null : !((Object)this$executeLocally).equals(other$executeLocally)) {
            return false;
        }
        Integer this$beginAtLineNumber = this.getBeginAtLineNumber();
        Integer other$beginAtLineNumber = other.getBeginAtLineNumber();
        if (this$beginAtLineNumber == null ? other$beginAtLineNumber != null : !((Object)this$beginAtLineNumber).equals(other$beginAtLineNumber)) {
            return false;
        }
        Integer this$endAtLineNumber = this.getEndAtLineNumber();
        Integer other$endAtLineNumber = other.getEndAtLineNumber();
        if (this$endAtLineNumber == null ? other$endAtLineNumber != null : !((Object)this$endAtLineNumber).equals(other$endAtLineNumber)) {
            return false;
        }
        String this$commandLine = this.getCommandLine();
        String other$commandLine = other.getCommandLine();
        if (this$commandLine == null ? other$commandLine != null : !this$commandLine.equals(other$commandLine)) {
            return false;
        }
        String this$exclude = this.getExclude();
        String other$exclude = other.getExclude();
        if (this$exclude == null ? other$exclude != null : !this$exclude.equals(other$exclude)) {
            return false;
        }
        String this$keep = this.getKeep();
        String other$keep = other.getKeep();
        if (this$keep == null ? other$keep != null : !this$keep.equals(other$keep)) {
            return false;
        }
        String this$separators = this.getSeparators();
        String other$separators = other.getSeparators();
        if (this$separators == null ? other$separators != null : !this$separators.equals(other$separators)) {
            return false;
        }
        String this$selectColumns = this.getSelectColumns();
        String other$selectColumns = other.getSelectColumns();
        return !(this$selectColumns == null ? other$selectColumns != null : !this$selectColumns.equals(other$selectColumns));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandLineSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Boolean $executeLocally = this.getExecuteLocally();
        result = result * 59 + ($executeLocally == null ? 43 : ((Object)$executeLocally).hashCode());
        Integer $beginAtLineNumber = this.getBeginAtLineNumber();
        result = result * 59 + ($beginAtLineNumber == null ? 43 : ((Object)$beginAtLineNumber).hashCode());
        Integer $endAtLineNumber = this.getEndAtLineNumber();
        result = result * 59 + ($endAtLineNumber == null ? 43 : ((Object)$endAtLineNumber).hashCode());
        String $commandLine = this.getCommandLine();
        result = result * 59 + ($commandLine == null ? 43 : $commandLine.hashCode());
        String $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : $exclude.hashCode());
        String $keep = this.getKeep();
        result = result * 59 + ($keep == null ? 43 : $keep.hashCode());
        String $separators = this.getSeparators();
        result = result * 59 + ($separators == null ? 43 : $separators.hashCode());
        String $selectColumns = this.getSelectColumns();
        result = result * 59 + ($selectColumns == null ? 43 : $selectColumns.hashCode());
        return result;
    }

    @Generated
    public static class CommandLineSourceBuilder {
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String commandLine;
        @Generated
        private Long timeout;
        @Generated
        private Boolean executeLocally;
        @Generated
        private String exclude;
        @Generated
        private String keep;
        @Generated
        private Integer beginAtLineNumber;
        @Generated
        private Integer endAtLineNumber;
        @Generated
        private String separators;
        @Generated
        private String selectColumns;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        CommandLineSourceBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public CommandLineSourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public CommandLineSourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public CommandLineSourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="commandLine", required=true)
        @Generated
        public CommandLineSourceBuilder commandLine(@NonNull String commandLine) {
            if (commandLine == null) {
                throw new IllegalArgumentException("commandLine is marked non-null but is null");
            }
            this.commandLine = commandLine;
            return this;
        }

        @JsonProperty(value="timeout")
        @Generated
        public CommandLineSourceBuilder timeout(Long timeout2) {
            this.timeout = timeout2;
            return this;
        }

        @JsonProperty(value="executeLocally")
        @Generated
        public CommandLineSourceBuilder executeLocally(Boolean executeLocally) {
            this.executeLocally = executeLocally;
            return this;
        }

        @JsonProperty(value="exclude")
        @Generated
        public CommandLineSourceBuilder exclude(String exclude) {
            this.exclude = exclude;
            return this;
        }

        @JsonProperty(value="keep")
        @Generated
        public CommandLineSourceBuilder keep(String keep) {
            this.keep = keep;
            return this;
        }

        @JsonProperty(value="beginAtLineNumber")
        @Generated
        public CommandLineSourceBuilder beginAtLineNumber(Integer beginAtLineNumber) {
            this.beginAtLineNumber = beginAtLineNumber;
            return this;
        }

        @JsonProperty(value="endAtLineNumber")
        @Generated
        public CommandLineSourceBuilder endAtLineNumber(Integer endAtLineNumber) {
            this.endAtLineNumber = endAtLineNumber;
            return this;
        }

        @JsonProperty(value="separators")
        @Generated
        public CommandLineSourceBuilder separators(String separators) {
            this.separators = separators;
            return this;
        }

        @JsonProperty(value="selectColumns")
        @Generated
        public CommandLineSourceBuilder selectColumns(String selectColumns) {
            this.selectColumns = selectColumns;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public CommandLineSourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public CommandLineSourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }

        @Generated
        public CommandLineSource build() {
            return new CommandLineSource(this.type, this.computes, this.forceSerialization, this.commandLine, this.timeout, this.executeLocally, this.exclude, this.keep, this.beginAtLineNumber, this.endAtLineNumber, this.separators, this.selectColumns, this.key, this.executeForEachEntryOf);
        }

        @Generated
        public String toString() {
            return "CommandLineSource.CommandLineSourceBuilder(type=" + this.type + ", computes=" + String.valueOf(this.computes) + ", forceSerialization=" + this.forceSerialization + ", commandLine=" + this.commandLine + ", timeout=" + this.timeout + ", executeLocally=" + this.executeLocally + ", exclude=" + this.exclude + ", keep=" + this.keep + ", beginAtLineNumber=" + this.beginAtLineNumber + ", endAtLineNumber=" + this.endAtLineNumber + ", separators=" + this.separators + ", selectColumns=" + this.selectColumns + ", key=" + this.key + ", executeForEachEntryOf=" + String.valueOf(this.executeForEachEntryOf) + ")";
        }
    }
}

