/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class CopySource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String from;

    @JsonCreator
    public CopySource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="from", required=true) @NonNull String from, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        if (from == null) {
            throw new IllegalArgumentException("from is marked non-null but is null");
        }
        this.from = from;
    }

    @Override
    public CopySource copy() {
        return CopySource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).from(this.from).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.from = (String)updater.apply(this.from);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- from=", this.from);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static CopySourceBuilder builder() {
        return new CopySourceBuilder();
    }

    @NonNull
    @Generated
    public String getFrom() {
        return this.from;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setFrom(@NonNull String from) {
        if (from == null) {
            throw new IllegalArgumentException("from is marked non-null but is null");
        }
        this.from = from;
    }

    @Generated
    public CopySource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopySource)) {
            return false;
        }
        CopySource other = (CopySource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CopySource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    @Generated
    public static class CopySourceBuilder {
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String from;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        CopySourceBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public CopySourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public CopySourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public CopySourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="from", required=true)
        @Generated
        public CopySourceBuilder from(@NonNull String from) {
            if (from == null) {
                throw new IllegalArgumentException("from is marked non-null but is null");
            }
            this.from = from;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public CopySourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public CopySourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }

        @Generated
        public CopySource build() {
            return new CopySource(this.type, this.computes, this.forceSerialization, this.from, this.key, this.executeForEachEntryOf);
        }

        @Generated
        public String toString() {
            return "CopySource.CopySourceBuilder(type=" + this.type + ", computes=" + String.valueOf(this.computes) + ", forceSerialization=" + this.forceSerialization + ", from=" + this.from + ", key=" + this.key + ", executeForEachEntryOf=" + String.valueOf(this.executeForEachEntryOf) + ")";
        }
    }
}

