/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.PositiveIntegerDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class TableJoinSource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String leftTable;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String rightTable;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    private Integer leftKeyColumn;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    private Integer rightKeyColumn;
    private String defaultRightLine;
    private String keyType;

    @JsonCreator
    public TableJoinSource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="leftTable", required=true) String leftTable, @JsonProperty(value="rightTable", required=true) String rightTable, @JsonProperty(value="leftKeyColumn", required=true) Integer leftKeyColumn, @JsonProperty(value="rightKeyColumn", required=true) Integer rightKeyColumn, @JsonProperty(value="defaultRightLine") String defaultRightLine, @JsonProperty(value="keyType") String keyType, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.leftKeyColumn = leftKeyColumn;
        this.rightKeyColumn = rightKeyColumn;
        this.defaultRightLine = defaultRightLine;
        this.keyType = keyType;
    }

    @Override
    public TableJoinSource copy() {
        return TableJoinSource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).leftTable(this.leftTable).rightTable(this.rightTable).leftKeyColumn(this.leftKeyColumn).rightKeyColumn(this.rightKeyColumn).defaultRightLine(this.defaultRightLine).keyType(this.keyType).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.leftTable = (String)updater.apply(this.leftTable);
        this.rightTable = (String)updater.apply(this.rightTable);
        this.keyType = (String)updater.apply(this.keyType);
        this.defaultRightLine = (String)updater.apply(this.defaultRightLine);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- leftTable=", this.leftTable);
        StringHelper.addNonNull(stringJoiner, "- rightTable=", this.rightTable);
        StringHelper.addNonNull(stringJoiner, "- leftKeyColumn=", this.leftKeyColumn);
        StringHelper.addNonNull(stringJoiner, "- rightKeyColumn=", this.rightKeyColumn);
        StringHelper.addNonNull(stringJoiner, "- defaultRightLine=", this.defaultRightLine);
        StringHelper.addNonNull(stringJoiner, "- keyType=", this.keyType);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static TableJoinSourceBuilder builder() {
        return new TableJoinSourceBuilder();
    }

    @Generated
    public String getLeftTable() {
        return this.leftTable;
    }

    @Generated
    public String getRightTable() {
        return this.rightTable;
    }

    @Generated
    public Integer getLeftKeyColumn() {
        return this.leftKeyColumn;
    }

    @Generated
    public Integer getRightKeyColumn() {
        return this.rightKeyColumn;
    }

    @Generated
    public String getDefaultRightLine() {
        return this.defaultRightLine;
    }

    @Generated
    public String getKeyType() {
        return this.keyType;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setLeftTable(String leftTable) {
        this.leftTable = leftTable;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setRightTable(String rightTable) {
        this.rightTable = rightTable;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    @Generated
    public void setLeftKeyColumn(Integer leftKeyColumn) {
        this.leftKeyColumn = leftKeyColumn;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=PositiveIntegerDeserializer.class)
    @Generated
    public void setRightKeyColumn(Integer rightKeyColumn) {
        this.rightKeyColumn = rightKeyColumn;
    }

    @Generated
    public void setDefaultRightLine(String defaultRightLine) {
        this.defaultRightLine = defaultRightLine;
    }

    @Generated
    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    @Generated
    public TableJoinSource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableJoinSource)) {
            return false;
        }
        TableJoinSource other = (TableJoinSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$leftKeyColumn = this.getLeftKeyColumn();
        Integer other$leftKeyColumn = other.getLeftKeyColumn();
        if (this$leftKeyColumn == null ? other$leftKeyColumn != null : !((Object)this$leftKeyColumn).equals(other$leftKeyColumn)) {
            return false;
        }
        Integer this$rightKeyColumn = this.getRightKeyColumn();
        Integer other$rightKeyColumn = other.getRightKeyColumn();
        if (this$rightKeyColumn == null ? other$rightKeyColumn != null : !((Object)this$rightKeyColumn).equals(other$rightKeyColumn)) {
            return false;
        }
        String this$leftTable = this.getLeftTable();
        String other$leftTable = other.getLeftTable();
        if (this$leftTable == null ? other$leftTable != null : !this$leftTable.equals(other$leftTable)) {
            return false;
        }
        String this$rightTable = this.getRightTable();
        String other$rightTable = other.getRightTable();
        if (this$rightTable == null ? other$rightTable != null : !this$rightTable.equals(other$rightTable)) {
            return false;
        }
        String this$defaultRightLine = this.getDefaultRightLine();
        String other$defaultRightLine = other.getDefaultRightLine();
        if (this$defaultRightLine == null ? other$defaultRightLine != null : !this$defaultRightLine.equals(other$defaultRightLine)) {
            return false;
        }
        String this$keyType = this.getKeyType();
        String other$keyType = other.getKeyType();
        return !(this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableJoinSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $leftKeyColumn = this.getLeftKeyColumn();
        result = result * 59 + ($leftKeyColumn == null ? 43 : ((Object)$leftKeyColumn).hashCode());
        Integer $rightKeyColumn = this.getRightKeyColumn();
        result = result * 59 + ($rightKeyColumn == null ? 43 : ((Object)$rightKeyColumn).hashCode());
        String $leftTable = this.getLeftTable();
        result = result * 59 + ($leftTable == null ? 43 : $leftTable.hashCode());
        String $rightTable = this.getRightTable();
        result = result * 59 + ($rightTable == null ? 43 : $rightTable.hashCode());
        String $defaultRightLine = this.getDefaultRightLine();
        result = result * 59 + ($defaultRightLine == null ? 43 : $defaultRightLine.hashCode());
        String $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        return result;
    }

    @Generated
    public static class TableJoinSourceBuilder {
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String leftTable;
        @Generated
        private String rightTable;
        @Generated
        private Integer leftKeyColumn;
        @Generated
        private Integer rightKeyColumn;
        @Generated
        private String defaultRightLine;
        @Generated
        private String keyType;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        TableJoinSourceBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public TableJoinSourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public TableJoinSourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public TableJoinSourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="leftTable", required=true)
        @Generated
        public TableJoinSourceBuilder leftTable(String leftTable) {
            this.leftTable = leftTable;
            return this;
        }

        @JsonProperty(value="rightTable", required=true)
        @Generated
        public TableJoinSourceBuilder rightTable(String rightTable) {
            this.rightTable = rightTable;
            return this;
        }

        @JsonProperty(value="leftKeyColumn", required=true)
        @Generated
        public TableJoinSourceBuilder leftKeyColumn(Integer leftKeyColumn) {
            this.leftKeyColumn = leftKeyColumn;
            return this;
        }

        @JsonProperty(value="rightKeyColumn", required=true)
        @Generated
        public TableJoinSourceBuilder rightKeyColumn(Integer rightKeyColumn) {
            this.rightKeyColumn = rightKeyColumn;
            return this;
        }

        @JsonProperty(value="defaultRightLine")
        @Generated
        public TableJoinSourceBuilder defaultRightLine(String defaultRightLine) {
            this.defaultRightLine = defaultRightLine;
            return this;
        }

        @JsonProperty(value="keyType")
        @Generated
        public TableJoinSourceBuilder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public TableJoinSourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public TableJoinSourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }

        @Generated
        public TableJoinSource build() {
            return new TableJoinSource(this.type, this.computes, this.forceSerialization, this.leftTable, this.rightTable, this.leftKeyColumn, this.rightKeyColumn, this.defaultRightLine, this.keyType, this.key, this.executeForEachEntryOf);
        }

        @Generated
        public String toString() {
            return "TableJoinSource.TableJoinSourceBuilder(type=" + this.type + ", computes=" + String.valueOf(this.computes) + ", forceSerialization=" + this.forceSerialization + ", leftTable=" + this.leftTable + ", rightTable=" + this.rightTable + ", leftKeyColumn=" + this.leftKeyColumn + ", rightKeyColumn=" + this.rightKeyColumn + ", defaultRightLine=" + this.defaultRightLine + ", keyType=" + this.keyType + ", key=" + this.key + ", executeForEachEntryOf=" + String.valueOf(this.executeForEachEntryOf) + ")";
        }
    }
}

