/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;
import org.sentrysoftware.metricshub.engine.connector.parser.JsonNodeUpdater;

public class TemplateVariableProcessor
extends AbstractNodeProcessor {
    @NonNull
    private Map<String, String> connectorVariables = new HashMap<String, String>();

    public TemplateVariableProcessor(@NonNull Map<String, String> connectorVariables, AbstractNodeProcessor next) {
        super(next);
        if (connectorVariables == null) {
            throw new IllegalArgumentException("connectorVariables is marked non-null but is null");
        }
        this.connectorVariables = connectorVariables;
    }

    @Override
    public JsonNode processNode(JsonNode node) throws IOException {
        UnaryOperator variableValueUpdater = value -> this.performReplacements(this.connectorVariables, (String)value);
        Predicate<String> isMatchingConnectorVariableRegex = str -> str != null && str.contains("${var::");
        JsonNodeUpdater.jsonNodeUpdaterBuilder().withJsonNode(node).withPredicate(isMatchingConnectorVariableRegex).withUpdater(variableValueUpdater).build().update();
        return node;
    }

    private String performReplacements(Map<String, String> replacements, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            String key = entry.getKey();
            Pattern pattern = Pattern.compile(String.format("\\$\\{var\\:\\:%s\\}", key));
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                value = value.replace(matcher.group(), entry.getValue());
            }
        }
        return value;
    }

    @Generated
    public static TemplateVariableProcessorBuilder builder() {
        return new TemplateVariableProcessorBuilder();
    }

    @NonNull
    @Generated
    public Map<String, String> getConnectorVariables() {
        return this.connectorVariables;
    }

    @Generated
    public void setConnectorVariables(@NonNull Map<String, String> connectorVariables) {
        if (connectorVariables == null) {
            throw new IllegalArgumentException("connectorVariables is marked non-null but is null");
        }
        this.connectorVariables = connectorVariables;
    }

    @Override
    @Generated
    public String toString() {
        return "TemplateVariableProcessor(connectorVariables=" + String.valueOf(this.getConnectorVariables()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateVariableProcessor)) {
            return false;
        }
        TemplateVariableProcessor other = (TemplateVariableProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$connectorVariables = this.getConnectorVariables();
        Map<String, String> other$connectorVariables = other.getConnectorVariables();
        return !(this$connectorVariables == null ? other$connectorVariables != null : !((Object)this$connectorVariables).equals(other$connectorVariables));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TemplateVariableProcessor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $connectorVariables = this.getConnectorVariables();
        result = result * 59 + ($connectorVariables == null ? 43 : ((Object)$connectorVariables).hashCode());
        return result;
    }

    @Generated
    public static class TemplateVariableProcessorBuilder {
        @Generated
        private Map<String, String> connectorVariables;
        @Generated
        private AbstractNodeProcessor next;

        @Generated
        TemplateVariableProcessorBuilder() {
        }

        @Generated
        public TemplateVariableProcessorBuilder connectorVariables(@NonNull Map<String, String> connectorVariables) {
            if (connectorVariables == null) {
                throw new IllegalArgumentException("connectorVariables is marked non-null but is null");
            }
            this.connectorVariables = connectorVariables;
            return this;
        }

        @Generated
        public TemplateVariableProcessorBuilder next(AbstractNodeProcessor next) {
            this.next = next;
            return this;
        }

        @Generated
        public TemplateVariableProcessor build() {
            return new TemplateVariableProcessor(this.connectorVariables, this.next);
        }

        @Generated
        public String toString() {
            return "TemplateVariableProcessor.TemplateVariableProcessorBuilder(connectorVariables=" + String.valueOf(this.connectorVariables) + ", next=" + String.valueOf(this.next) + ")";
        }
    }
}

