/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.collect;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.ConnectorMonitorTypeComparator;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.StandardMonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.AbstractCollect;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Mapping;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.MultiInstanceCollect;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.strategy.source.OrderedSources;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.surrounding.AfterAllStrategy;
import org.sentrysoftware.metricshub.engine.strategy.surrounding.BeforeAllStrategy;
import org.sentrysoftware.metricshub.engine.strategy.utils.MappingProcessor;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectStrategy
extends AbstractStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CollectStrategy.class);
    private static final String JOB_NAME = "collect";

    public CollectStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
    }

    private void collect(Connector currentConnector, String hostname) {
        boolean connectorHasExpectedJobTypes = this.hasExpectedJobTypes(currentConnector, JOB_NAME);
        if (!connectorHasExpectedJobTypes) {
            log.debug("Connector doesn't define any monitor job of type collect.");
            return;
        }
        if (!this.validateConnectorDetectionCriteria(currentConnector, hostname, JOB_NAME)) {
            log.error("Hostname {} - The connector {} no longer matches the host. Stopping the connector's collect job.", (Object)hostname, (Object)currentConnector.getCompiledFilename());
            return;
        }
        BeforeAllStrategy beforeAllStrategy = BeforeAllStrategy.builder().clientsExecutor(this.clientsExecutor).strategyTime(this.strategyTime).telemetryManager(this.telemetryManager).connector(currentConnector).extensionManager(this.extensionManager).build();
        beforeAllStrategy.run();
        Map connectorMonitorJobs = currentConnector.getMonitors().entrySet().stream().sorted(Comparator.comparing(entry -> MetricsHubConstants.MONITOR_JOBS_PRIORITY.containsKey(entry.getKey()) ? MetricsHubConstants.MONITOR_JOBS_PRIORITY.get(entry.getKey()) : MetricsHubConstants.MONITOR_JOBS_PRIORITY.get("otherMonitorJobTypes"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        Map sequentialMonitorJobs = connectorMonitorJobs.entrySet().stream().filter(entry -> MetricsHubConstants.MONITOR_JOBS_PRIORITY.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        Map otherMonitorJobs = connectorMonitorJobs.entrySet().stream().filter(entry -> !MetricsHubConstants.MONITOR_JOBS_PRIORITY.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        sequentialMonitorJobs.entrySet().forEach(entry -> this.processMonitorJob(currentConnector, hostname, (Map.Entry<String, MonitorJob>)entry));
        if (this.telemetryManager.getHostConfiguration().isSequential()) {
            otherMonitorJobs.entrySet().forEach(entry -> this.processMonitorJob(currentConnector, hostname, (Map.Entry<String, MonitorJob>)entry));
        } else {
            log.info("Hostname {} - Running collect in parallel mode. Connector: {}.", (Object)hostname, (Object)currentConnector.getConnectorIdentity().getCompiledFilename());
            ExecutorService threadsPool = Executors.newFixedThreadPool(50);
            otherMonitorJobs.entrySet().forEach(entry -> threadsPool.execute(() -> this.processMonitorJob(currentConnector, hostname, (Map.Entry<String, MonitorJob>)entry)));
            threadsPool.shutdown();
            try {
                threadsPool.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.debug("Hostname {} - Waiting for threads' termination aborted with an error.", (Object)hostname, (Object)e);
            }
        }
        AfterAllStrategy afterAllStrategy = AfterAllStrategy.builder().clientsExecutor(this.clientsExecutor).strategyTime(this.strategyTime).telemetryManager(this.telemetryManager).connector(currentConnector).extensionManager(this.extensionManager).build();
        afterAllStrategy.run();
    }

    private void processMonitorJob(Connector currentConnector, String hostname, Map.Entry<String, MonitorJob> monitorJob) {
        long jobStartTime = System.currentTimeMillis();
        MonitorJob monitorJob2 = monitorJob.getValue();
        if (monitorJob2 instanceof StandardMonitorJob) {
            StandardMonitorJob standardMonitorJob = (StandardMonitorJob)monitorJob2;
            AbstractCollect collect = standardMonitorJob.getCollect();
            if (collect == null) {
                return;
            }
            String monitorType = monitorJob.getKey();
            if (this.isMonitorFiltered(monitorType)) {
                return;
            }
            JobInfo jobInfo = JobInfo.builder().hostname(hostname).connectorId(currentConnector.getCompiledFilename()).jobName(collect.getClass().getSimpleName()).monitorType(monitorType).build();
            OrderedSources orderedSources = OrderedSources.builder().sources(collect.getSources(), collect.getExecutionOrder().stream().toList(), collect.getSourceDep(), jobInfo).build();
            if (collect instanceof MultiInstanceCollect) {
                MultiInstanceCollect multiInstanceCollect = (MultiInstanceCollect)collect;
                Map<String, Monitor> monitors = this.telemetryManager.findMonitorsByType(monitorType);
                if (monitors == null) {
                    return;
                }
                this.processSourcesAndComputes(orderedSources.getSources(), jobInfo);
                Set<String> monitorJobKeys = monitorJob.getValue().getKeys();
                this.processMonitors(monitorType, multiInstanceCollect.getMapping(), currentConnector, hostname, monitorJobKeys);
            } else {
                Map<String, Monitor> sameTypeMonitors = this.telemetryManager.findMonitorsByType(monitorType);
                if (sameTypeMonitors != null && !sameTypeMonitors.isEmpty()) {
                    sameTypeMonitors.values().stream().filter(monitor -> currentConnector.getCompiledFilename().equals(monitor.getAttribute("connector_id"))).forEach(monitor -> {
                        this.processSourcesAndComputes(orderedSources.getSources(), monitor.getAttributes(), jobInfo);
                        this.processMonitors(monitorType, collect.getMapping(), currentConnector, hostname, (Monitor)monitor);
                    });
                }
            }
            long jobEndTime = System.currentTimeMillis();
            this.setJobDurationMetric(JOB_NAME, monitorType, currentConnector.getCompiledFilename(), jobStartTime, jobEndTime);
        }
    }

    private void processMonitors(String monitorType, Mapping mapping, Connector connector, String hostname, Set<String> keys2) {
        this.processMonitors(monitorType, mapping, connector, hostname, Optional.empty(), keys2);
    }

    private void processMonitors(String monitorType, Mapping mapping, Connector connector, String hostname, Monitor monitor) {
        this.processMonitors(monitorType, mapping, connector, hostname, Optional.of(monitor), null);
    }

    private void processMonitors(String monitorType, Mapping mapping, Connector connector, String hostname, Optional<Monitor> maybeMonitor, Set<String> attributeKeys) {
        if (mapping == null) {
            return;
        }
        String connectorId = connector.getCompiledFilename();
        String mappingSource = mapping.getSource();
        Optional<SourceTable> maybeSourceTable = SourceTable.lookupSourceTable(mappingSource, connectorId, this.telemetryManager);
        if (maybeSourceTable.isEmpty()) {
            log.debug("Hostname {} - Collect - No source table created with source key {} for connector {}.", hostname, mappingSource, connectorId);
            return;
        }
        List<List<String>> table = maybeSourceTable.get().getTable();
        if (table.isEmpty()) {
            return;
        }
        log.debug("Hostname {} - Start collect {} mapping with source {}, attributes {}, metrics {}, conditional collection {}, legacy text parameters {} and resource{}. Connector ID: {}.", hostname, monitorType, mapping.getSource(), mapping.getAttributes(), mapping.getMetrics(), mapping.getConditionalCollection(), mapping.getLegacyTextParameters(), mapping.getResource(), connectorId);
        int rowCountLimit = maybeMonitor.isEmpty() ? table.size() : 1;
        Map<String, Monitor> sameTypeMonitors = this.telemetryManager.findMonitorsByType(monitorType);
        for (int i = 0; i < rowCountLimit; ++i) {
            List<String> row = table.get(i);
            MappingProcessor mappingProcessor = MappingProcessor.builder().telemetryManager(this.telemetryManager).mapping(mapping).jobInfo(JobInfo.builder().connectorId(connectorId).hostname(hostname).monitorType(monitorType).jobName(JOB_NAME).build()).collectTime(this.strategyTime).row(row).indexCounter(i + 1).build();
            maybeMonitor.or(() -> this.findMonitor(connectorId, sameTypeMonitors, mappingProcessor.interpretNonContextMappingAttributes(), attributeKeys)).ifPresent(monitor -> {
                Map<String, String> metrics = mappingProcessor.interpretNonContextMappingMetrics();
                metrics.putAll(mappingProcessor.interpretContextMappingMetrics((Monitor)monitor));
                MetricFactory metricFactory = new MetricFactory(hostname);
                metricFactory.collectMonitorMetrics(monitorType, connector, (Monitor)monitor, connectorId, metrics, this.strategyTime, false);
                monitor.addLegacyParameters(mappingProcessor.interpretNonContextMappingLegacyTextParameters());
                monitor.addLegacyParameters(mappingProcessor.interpretContextMappingLegacyTextParameters((Monitor)monitor));
            });
        }
    }

    private Optional<Monitor> findMonitor(String connectorId, Map<String, Monitor> sameTypeMonitors, Map<String, String> collectedAttributeValues, Set<String> attributeKeys) {
        return sameTypeMonitors.values().stream().filter(monitor -> this.matchMonitorAttributes((Monitor)monitor, collectedAttributeValues, attributeKeys) && connectorId.equals(monitor.getAttribute("connector_id"))).findFirst();
    }

    private boolean matchMonitorAttributes(Monitor monitor, Map<String, String> collectedAttributeValues, Set<String> attributeKeys) {
        return attributeKeys.stream().allMatch(key -> {
            String monitorAttributeValue = monitor.getAttribute((String)key);
            if (monitorAttributeValue == null) {
                return false;
            }
            String collectedAttributeValue = (String)collectedAttributeValues.get(key);
            if (collectedAttributeValue == null) {
                return false;
            }
            return monitorAttributeValue.equals(collectedAttributeValue);
        });
    }

    @Override
    public void run() {
        String hostname = this.telemetryManager.getHostname();
        Map<String, Monitor> connectorMonitors = this.telemetryManager.getMonitors().get(KnownMonitorType.CONNECTOR.getKey());
        if (connectorMonitors == null || connectorMonitors.isEmpty()) {
            log.error("Hostname {} - Collect - No connectors detected in the detection operation. Collect operation will now be stopped.", (Object)hostname);
            return;
        }
        ConnectorStore connectorStore = this.telemetryManager.getConnectorStore();
        Set detectedConnectorFileNames = connectorMonitors.values().stream().map(monitor -> monitor.getAttributes().get("id")).collect(Collectors.toSet());
        List<Connector> detectedConnectors = connectorStore.getStore().entrySet().stream().filter(entry -> detectedConnectorFileNames.contains(entry.getKey())).map(Map.Entry::getValue).toList();
        List<Connector> connectorsWithMonitorJobs = detectedConnectors.stream().filter(connector -> !connector.getMonitors().isEmpty()).toList();
        List<Connector> sortedConnectors = connectorsWithMonitorJobs.stream().sorted(new ConnectorMonitorTypeComparator()).toList();
        sortedConnectors.forEach(connector -> this.collect((Connector)connector, hostname));
    }

    @Generated
    public static CollectStrategyBuilder builder() {
        return new CollectStrategyBuilder();
    }

    @Generated
    public CollectStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectStrategy)) {
            return false;
        }
        CollectStrategy other = (CollectStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CollectStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public static class CollectStrategyBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Long strategyTime;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        CollectStrategyBuilder() {
        }

        @Generated
        public CollectStrategyBuilder telemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public CollectStrategyBuilder strategyTime(@NonNull Long strategyTime) {
            if (strategyTime == null) {
                throw new IllegalArgumentException("strategyTime is marked non-null but is null");
            }
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public CollectStrategyBuilder clientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
            if (clientsExecutor == null) {
                throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
            }
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public CollectStrategyBuilder extensionManager(@NonNull ExtensionManager extensionManager) {
            if (extensionManager == null) {
                throw new IllegalArgumentException("extensionManager is marked non-null but is null");
            }
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public CollectStrategy build() {
            return new CollectStrategy(this.telemetryManager, this.strategyTime, this.clientsExecutor, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "CollectStrategy.CollectStrategyBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", strategyTime=" + this.strategyTime + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

