/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.common.helpers.VersionHelper;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.DeviceTypeCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.HttpCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProcessCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProductRequirementsCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ServiceCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetNextCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SqlCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WbemCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionProcessorRegistry;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.CriterionProcessVisitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriterionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CriterionProcessor.class);
    private static final String CONFIGURE_OS_TYPE_MESSAGE = "Configured OS type : ";
    private ClientsExecutor clientsExecutor;
    private ExtensionManager extensionManager;
    private TelemetryManager telemetryManager;
    private String connectorId;

    public CriterionProcessor(ClientsExecutor clientsExecutor, TelemetryManager telemetryManager, String connectorId, ExtensionManager extensionManager) {
        this.clientsExecutor = clientsExecutor;
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.extensionManager = extensionManager;
    }

    @WithSpan(value="Criterion DeviceType Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") DeviceTypeCriterion deviceTypeCriterion) {
        if (deviceTypeCriterion == null) {
            log.error("Hostname {} - Malformed DeviceType criterion {}. Cannot process DeviceType criterion detection.", (Object)this.telemetryManager.getHostname(), (Object)deviceTypeCriterion);
            return CriterionTestResult.empty();
        }
        DeviceKind deviceKind = this.telemetryManager.getHostConfiguration().getHostType();
        if (!this.isDeviceKindIncluded(Collections.singletonList(deviceKind), deviceTypeCriterion)) {
            return CriterionTestResult.builder().message("Failed OS detection operation").result(CONFIGURE_OS_TYPE_MESSAGE + deviceKind.name()).success(false).criterion(deviceTypeCriterion).build();
        }
        return CriterionTestResult.builder().message("Successful OS detection operation").result(CONFIGURE_OS_TYPE_MESSAGE + deviceKind.name()).success(true).criterion(deviceTypeCriterion).build();
    }

    public boolean isDeviceKindIncluded(List<DeviceKind> deviceKindList, DeviceTypeCriterion deviceTypeCriterion) {
        Set<DeviceKind> keepOnly = deviceTypeCriterion.getKeep();
        Set<DeviceKind> exclude = deviceTypeCriterion.getExclude();
        if (keepOnly != null) {
            if (deviceKindList.stream().anyMatch(keepOnly::contains)) {
                return true;
            }
        }
        if (exclude != null) {
            if (deviceKindList.stream().anyMatch(exclude::contains)) {
                return false;
            }
        }
        return keepOnly == null || keepOnly.isEmpty();
    }

    @WithSpan(value="Criterion HTTP Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") HttpCriterion httpCriterion) {
        return this.processCriterionThroughExtension(httpCriterion);
    }

    @WithSpan(value="Criterion IPMI Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") IpmiCriterion ipmiCriterion) {
        DeviceKind hostType = this.telemetryManager.getHostConfiguration().getHostType();
        if (DeviceKind.WINDOWS.equals((Object)hostType) || DeviceKind.LINUX.equals((Object)hostType) || DeviceKind.SOLARIS.equals((Object)hostType) || DeviceKind.OOB.equals((Object)hostType)) {
            return this.processCriterionThroughExtension(ipmiCriterion);
        }
        return CriterionTestResult.builder().message(String.format("Hostname %s - Failed to perform IPMI detection. %s is an unsupported OS for IPMI.", this.telemetryManager.getHostname(), hostType.name())).success(false).build();
    }

    @WithSpan(value="Criterion OS Command Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") CommandLineCriterion commandLineCriterion) {
        return this.processCriterionThroughExtension(commandLineCriterion);
    }

    @WithSpan(value="Criterion Process Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") ProcessCriterion processCriterion) {
        String hostname = this.telemetryManager.getHostname();
        if (processCriterion == null) {
            log.error("Hostname {} - Malformed process criterion {}. Cannot process process detection.", (Object)hostname, (Object)processCriterion);
            return CriterionTestResult.empty();
        }
        if (processCriterion.getCommandLine().isEmpty()) {
            log.debug("Hostname {} - Process Criterion, Process Command Line is empty.", (Object)hostname);
            return CriterionTestResult.builder().success(true).message("Process presence check: No test will be performed.").result(null).criterion(processCriterion).build();
        }
        if (!this.telemetryManager.getHostProperties().isLocalhost()) {
            log.debug("Hostname {} - Process criterion, not localhost.", (Object)hostname);
            return CriterionTestResult.builder().success(true).message("Process presence check: No test will be performed remotely.").result(null).criterion(processCriterion).build();
        }
        Optional<LocalOsHandler.ILocalOs> maybeLocalOS = LocalOsHandler.getOS();
        if (maybeLocalOS.isEmpty()) {
            log.debug("Hostname {} - Process criterion, unknown local OS.", (Object)hostname);
            return CriterionTestResult.builder().success(true).message("Process presence check: OS unknown, no test will be performed.").result(null).criterion(processCriterion).build();
        }
        CriterionProcessVisitor localOSVisitor = new CriterionProcessVisitor(this.extensionManager, processCriterion, hostname);
        maybeLocalOS.get().accept(localOSVisitor);
        CriterionTestResult result = localOSVisitor.getCriterionTestResult();
        if (result != null) {
            result.setCriterion(processCriterion);
            return result;
        }
        return CriterionTestResult.error((Criterion)processCriterion, "Process presence check: No result returned by the criterion processor.");
    }

    @WithSpan(value="Criterion ProductRequirements Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") ProductRequirementsCriterion productRequirementsCriterion) {
        if (productRequirementsCriterion == null || productRequirementsCriterion.getEngineVersion() == null || productRequirementsCriterion.getEngineVersion().isBlank()) {
            return CriterionTestResult.builder().success(true).criterion(productRequirementsCriterion).build();
        }
        return CriterionTestResult.builder().success(VersionHelper.isVersionLessThanOtherVersion(productRequirementsCriterion.getEngineVersion(), VersionHelper.getClassVersion())).criterion(productRequirementsCriterion).build();
    }

    @WithSpan(value="Criterion Service Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") ServiceCriterion serviceCriterion) {
        return this.processCriterionThroughExtension(serviceCriterion);
    }

    @WithSpan(value="Criterion SNMP Get Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") SnmpGetCriterion snmpGetCriterion) {
        return this.processCriterionThroughExtension(snmpGetCriterion);
    }

    @WithSpan(value="Criterion Exec Through Extension")
    public CriterionTestResult processCriterionThroughExtension(@SpanAttribute(value="criterion.definition") Criterion criterion) {
        Optional<IProtocolExtension> maybeExtension = this.extensionManager.findCriterionExtension(criterion, this.telemetryManager);
        return maybeExtension.map(extension -> {
            CriterionTestResult result = extension.processCriterion(criterion, this.connectorId, this.telemetryManager);
            if (result != null) {
                result.setCriterion(criterion);
            }
            return result;
        }).orElseGet(CriterionTestResult::empty);
    }

    @WithSpan(value="Criterion SNMP GetNext Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") SnmpGetNextCriterion snmpGetNextCriterion) {
        return this.processCriterionThroughExtension(snmpGetNextCriterion);
    }

    @WithSpan(value="Criterion WMI Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") WmiCriterion wmiCriterion) {
        return this.processCriterionThroughExtension(wmiCriterion);
    }

    @WithSpan(value="Criterion WBEM Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") WbemCriterion wbemCriterion) {
        return this.processCriterionThroughExtension(wbemCriterion);
    }

    @WithSpan(value="Criterion SQL Exec")
    public CriterionTestResult process(@SpanAttribute(value="criterion.definition") SqlCriterion sqlCriterion) {
        return this.processCriterionThroughExtension(sqlCriterion);
    }

    public CriterionTestResult test(Criterion criterion) {
        return CriterionProcessorRegistry.getProcessor(criterion).apply(criterion, this);
    }

    @Generated
    public ClientsExecutor getClientsExecutor() {
        return this.clientsExecutor;
    }

    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public void setClientsExecutor(ClientsExecutor clientsExecutor) {
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CriterionProcessor)) {
            return false;
        }
        CriterionProcessor other = (CriterionProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClientsExecutor this$clientsExecutor = this.getClientsExecutor();
        ClientsExecutor other$clientsExecutor = other.getClientsExecutor();
        if (this$clientsExecutor == null ? other$clientsExecutor != null : !((Object)this$clientsExecutor).equals(other$clientsExecutor)) {
            return false;
        }
        ExtensionManager this$extensionManager = this.getExtensionManager();
        ExtensionManager other$extensionManager = other.getExtensionManager();
        if (this$extensionManager == null ? other$extensionManager != null : !((Object)this$extensionManager).equals(other$extensionManager)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        return !(this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CriterionProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClientsExecutor $clientsExecutor = this.getClientsExecutor();
        result = result * 59 + ($clientsExecutor == null ? 43 : ((Object)$clientsExecutor).hashCode());
        ExtensionManager $extensionManager = this.getExtensionManager();
        result = result * 59 + ($extensionManager == null ? 43 : ((Object)$extensionManager).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CriterionProcessor(clientsExecutor=" + String.valueOf(this.getClientsExecutor()) + ", extensionManager=" + String.valueOf(this.getExtensionManager()) + ", telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ")";
    }

    @Generated
    public CriterionProcessor() {
    }
}

