/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.CommandLineCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.DeviceTypeCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.HttpCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProcessCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ProductRequirementsCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.ServiceCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SnmpGetNextCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.SqlCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WbemCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionProcessor;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;

public class CriterionProcessorRegistry {
    private static final Map<Class<? extends Criterion>, BiFunction<Criterion, CriterionProcessor, CriterionTestResult>> PROCESSORS = new HashMap<Class<? extends Criterion>, BiFunction<Criterion, CriterionProcessor, CriterionTestResult>>();

    private static void registerProcessor(Class<? extends Criterion> criterionClass, BiFunction<Criterion, CriterionProcessor, CriterionTestResult> processor) {
        PROCESSORS.put(criterionClass, processor);
    }

    public static BiFunction<Criterion, CriterionProcessor, CriterionTestResult> getProcessor(Criterion criterion) {
        return PROCESSORS.getOrDefault(criterion.getClass(), (c, p) -> p.processCriterionThroughExtension((Criterion)c));
    }

    @Generated
    private CriterionProcessorRegistry() {
    }

    static {
        CriterionProcessorRegistry.registerProcessor(DeviceTypeCriterion.class, (criterion, processor) -> processor.process((DeviceTypeCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(HttpCriterion.class, (criterion, processor) -> processor.process((HttpCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(IpmiCriterion.class, (criterion, processor) -> processor.process((IpmiCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(CommandLineCriterion.class, (criterion, processor) -> processor.process((CommandLineCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(ProcessCriterion.class, (criterion, processor) -> processor.process((ProcessCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(ProductRequirementsCriterion.class, (criterion, processor) -> processor.process((ProductRequirementsCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(ServiceCriterion.class, (criterion, processor) -> processor.process((ServiceCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(SnmpGetCriterion.class, (criterion, processor) -> processor.process((SnmpGetCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(SnmpGetNextCriterion.class, (criterion, processor) -> processor.process((SnmpGetNextCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(WmiCriterion.class, (criterion, processor) -> processor.process((WmiCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(WbemCriterion.class, (criterion, processor) -> processor.process((WbemCriterion)criterion));
        CriterionProcessorRegistry.registerProcessor(SqlCriterion.class, (criterion, processor) -> processor.process((SqlCriterion)criterion));
    }
}

