/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.source.compute;

import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Add;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.And;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Append;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.ArrayTranslate;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Awk;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Convert;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Divide;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.DuplicateColumn;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.ExcludeMatchingLines;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Extract;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.ExtractPropertyFromWbemPath;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Json2Csv;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.KeepColumns;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.KeepOnlyMatchingLines;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Multiply;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.PerBitTranslation;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Prepend;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Replace;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Substring;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Subtract;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Translate;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Xml2Csv;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceUpdaterProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.compute.IComputeProcessor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;

public class ComputeUpdaterProcessor
implements IComputeProcessor {
    private IComputeProcessor computeProcessor;
    private TelemetryManager telemetryManager;
    private String connectorId;
    private Map<String, String> attributes;

    @Override
    public void process(ArrayTranslate arrayTranslate) {
        arrayTranslate.accept(this.computeProcessor);
    }

    @Override
    public void process(And and) {
        this.processCompute(and);
    }

    @Override
    public void process(Add add) {
        this.processCompute(add);
    }

    @Override
    public void process(Awk awk) {
        this.processCompute(awk);
    }

    @Override
    public void process(Convert convert) {
        this.processCompute(convert);
    }

    @Override
    public void process(Divide divide) {
        this.processCompute(divide);
    }

    @Override
    public void process(DuplicateColumn duplicateColumn) {
        this.processCompute(duplicateColumn);
    }

    @Override
    public void process(ExcludeMatchingLines excludeMatchingLines) {
        this.processCompute(excludeMatchingLines);
    }

    @Override
    public void process(Extract extract) {
        this.processCompute(extract);
    }

    @Override
    public void process(ExtractPropertyFromWbemPath extractPropertyFromWbemPath) {
        this.processCompute(extractPropertyFromWbemPath);
    }

    @Override
    public void process(Json2Csv json2csv) {
        this.processCompute(json2csv);
    }

    @Override
    public void process(KeepColumns keepColumns) {
        this.processCompute(keepColumns);
    }

    @Override
    public void process(KeepOnlyMatchingLines keepOnlyMatchingLines) {
        this.processCompute(keepOnlyMatchingLines);
    }

    @Override
    public void process(Prepend prepend) {
        this.processCompute(prepend);
    }

    @Override
    public void process(Multiply multiply) {
        this.processCompute(multiply);
    }

    @Override
    public void process(PerBitTranslation perBitTranslation) {
        this.processCompute(perBitTranslation);
    }

    @Override
    public void process(Replace replace) {
        this.processCompute(replace);
    }

    @Override
    public void process(Append append) {
        this.processCompute(append);
    }

    @Override
    public void process(Subtract subtract) {
        this.processCompute(subtract);
    }

    @Override
    public void process(Substring substring) {
        this.processCompute(substring);
    }

    @Override
    public void process(Translate translate) {
        this.processCompute(translate);
    }

    @Override
    public void process(Xml2Csv xml2csv) {
        this.processCompute(xml2csv);
    }

    private void processCompute(Compute origin) {
        Compute copy = origin.copy();
        copy.update(value -> SourceUpdaterProcessor.replaceAttributeReferences(value, this.attributes));
        copy.update(value -> this.replaceSourceReference((String)value, copy));
        copy.accept(this.computeProcessor);
    }

    private String replaceSourceReference(String value, Compute compute) {
        if (value == null) {
            return value;
        }
        return SourceUpdaterProcessor.replaceSourceReferenceContent(value, this.telemetryManager, this.connectorId, compute.getClass().getSimpleName(), compute.getType());
    }

    @Generated
    public static ComputeUpdaterProcessorBuilder builder() {
        return new ComputeUpdaterProcessorBuilder();
    }

    @Generated
    public IComputeProcessor getComputeProcessor() {
        return this.computeProcessor;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setComputeProcessor(IComputeProcessor computeProcessor) {
        this.computeProcessor = computeProcessor;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    @Generated
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputeUpdaterProcessor)) {
            return false;
        }
        ComputeUpdaterProcessor other = (ComputeUpdaterProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IComputeProcessor this$computeProcessor = this.getComputeProcessor();
        IComputeProcessor other$computeProcessor = other.getComputeProcessor();
        if (this$computeProcessor == null ? other$computeProcessor != null : !this$computeProcessor.equals(other$computeProcessor)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComputeUpdaterProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IComputeProcessor $computeProcessor = this.getComputeProcessor();
        result = result * 59 + ($computeProcessor == null ? 43 : $computeProcessor.hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComputeUpdaterProcessor(computeProcessor=" + String.valueOf(this.getComputeProcessor()) + ", telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", connectorId=" + this.getConnectorId() + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    @Generated
    public ComputeUpdaterProcessor(IComputeProcessor computeProcessor, TelemetryManager telemetryManager, String connectorId, Map<String, String> attributes) {
        this.computeProcessor = computeProcessor;
        this.telemetryManager = telemetryManager;
        this.connectorId = connectorId;
        this.attributes = attributes;
    }

    @Generated
    public ComputeUpdaterProcessor() {
    }

    @Generated
    public static class ComputeUpdaterProcessorBuilder {
        @Generated
        private IComputeProcessor computeProcessor;
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private String connectorId;
        @Generated
        private Map<String, String> attributes;

        @Generated
        ComputeUpdaterProcessorBuilder() {
        }

        @Generated
        public ComputeUpdaterProcessorBuilder computeProcessor(IComputeProcessor computeProcessor) {
            this.computeProcessor = computeProcessor;
            return this;
        }

        @Generated
        public ComputeUpdaterProcessorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public ComputeUpdaterProcessorBuilder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Generated
        public ComputeUpdaterProcessorBuilder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public ComputeUpdaterProcessor build() {
            return new ComputeUpdaterProcessor(this.computeProcessor, this.telemetryManager, this.connectorId, this.attributes);
        }

        @Generated
        public String toString() {
            return "ComputeUpdaterProcessor.ComputeUpdaterProcessorBuilder(computeProcessor=" + String.valueOf(this.computeProcessor) + ", telemetryManager=" + String.valueOf(this.telemetryManager) + ", connectorId=" + this.connectorId + ", attributes=" + String.valueOf(this.attributes) + ")";
        }
    }
}

