/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.common.helpers.FunctionArgumentsExtractor;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.common.helpers.state.DuplexMode;
import org.sentrysoftware.metricshub.engine.common.helpers.state.IntrusionStatus;
import org.sentrysoftware.metricshub.engine.common.helpers.state.LinkStatus;
import org.sentrysoftware.metricshub.engine.common.helpers.state.NeedsCleaning;
import org.sentrysoftware.metricshub.engine.common.helpers.state.PredictedFailure;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.mapping.MappingResource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Mapping;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceUpdaterProcessor;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.MathOperationsHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.Resource;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class MappingProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MappingProcessor.class);
    private static final String RESULT_MESSAGE = "As a result, {} cannot be updated.";
    private static final double MEBIBYTE_2_BYTE_FACTOR = 1048576.0;
    private static final double MEGABIT_2_BIT_FACTOR = 1000000.0;
    public static final double MEGABIT_2_BYTE_FACTOR = 125000.0;
    private static final double MEGAHERTZ_2_HERTZ_FACTOR = 1000000.0;
    private static final double MILLIVOLT_2_VOLT_FACTOR = 0.001;
    private static final double PERCENT_2_RATIO_FACTOR = 0.01;
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String TRUE = "true";
    private static final String INVALID_VALUE = "Hostname {} - Value {} is invalid for {}.";
    private static final Pattern MEBIBYTE_2_BYTE_PATTERN = Pattern.compile("mebibyte2byte\\((.+)\\)", 2);
    private static final Pattern MEGABIT_2_BYTE_PATTERN = Pattern.compile("megabit2byte\\((.+)\\)", 2);
    private static final Pattern MEGABIT_2_BIT_PATTERN = Pattern.compile("megabit2bit\\((.+)\\)", 2);
    private static final Pattern MEGAHERTZ_2_HERTZ_PATTERN = Pattern.compile("megahertz2hertz\\((.+)\\)", 2);
    private static final Pattern MILLIVOLT_2_VOLT_PATTERN = Pattern.compile("millivolt2volt\\((.+)\\)", 2);
    private static final Pattern PERCENT_2_RATIO_PATTERN = Pattern.compile("percent2ratio\\((.+)\\)", 2);
    private static final Pattern LEGACY_FULL_DUPLEX_PATTERN = Pattern.compile("legacyfullduplex\\((.+)\\)", 2);
    private static final Pattern LEGACY_LINK_STATUS_PATTERN = Pattern.compile("legacylinkstatus\\((.+)\\)", 2);
    private static final Pattern LEGACY_PREDICTED_FAILURE_PATTERN = Pattern.compile("legacypredictedfailure\\((.+)\\)", 2);
    private static final Pattern LEGACY_NEEDS_CLEANING_PATTERN = Pattern.compile("legacyneedscleaning\\((.+)\\)", 2);
    private static final Pattern LEGACY_INTRUSION_STATUS_PATTERN = Pattern.compile("legacyintrusionstatus\\((.+)\\)", 2);
    private static final Pattern LEGACY_POWER_SUPPLY_UTILIZATION_PATTERN = Pattern.compile("legacypowersupplyutilization\\((.+)\\)", 2);
    private static final Pattern LEGACY_LED_STATUS_PATTERN = Pattern.compile("legacyledstatus\\((.+)\\)", 2);
    private static final Pattern LOOKUP_PATTERN = Pattern.compile("lookup\\((.+)\\)", 2);
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("boolean\\((.+)\\)", 2);
    private static final Pattern FAKE_COUNTER_PATTERN = Pattern.compile("fakecounter\\((.+)\\)", 2);
    private static final Pattern RATE_PATTERN = Pattern.compile("rate\\((.+)\\)", 2);
    private static final Pattern COMPUTE_POWER_SHARE_RATIO_PATTERN = Pattern.compile("computepowershareratio\\((.+)\\)", 2);
    private static final Pattern AWK_SCRIPT_PATTERN = Pattern.compile("\\$\\{awk::.+\\}");
    private TelemetryManager telemetryManager;
    private Mapping mapping;
    private String id;
    private long collectTime;
    private List<String> row;
    private JobInfo jobInfo;
    private int indexCounter;
    private Map<String, BiFunction<KeyValuePair, Monitor, String>> computationFunctions;

    public Map<String, String> interpretNonContextMappingAttributes() {
        return this.interpretNonContextMapping(this.mapping.getAttributes());
    }

    public Map<String, String> interpretNonContextMappingMetrics() {
        return this.interpretNonContextMapping(this.mapping.getMetrics());
    }

    public Map<String, String> interpretNonContextMappingConditionalCollection() {
        return this.interpretNonContextMapping(this.mapping.getConditionalCollection());
    }

    public Map<String, String> interpretNonContextMappingLegacyTextParameters() {
        return this.interpretNonContextMapping(this.mapping.getLegacyTextParameters());
    }

    public Map<String, String> interpretNonContextMapping(Map<String, String> keyValuePairs) {
        if (keyValuePairs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        keyValuePairs.forEach((key, value) -> {
            String updatedValue = SourceUpdaterProcessor.replaceSourceReferenceContent(value, this.telemetryManager, this.jobInfo.getConnectorId(), "mapping", key);
            this.processKeyValue((String)key, updatedValue, (Map<String, String>)result);
        });
        return result;
    }

    private void processKeyValue(String key, String value, Map<String, String> result) {
        if (value == null) {
            return;
        }
        if (this.isColumnExtraction(value)) {
            result.put(key, this.extractColumnValue(value, key));
        } else if (this.isAwkScript(value)) {
            result.put(key, this.executeAwkScript(value, key));
        } else if (this.isMegaBit2Bit(value)) {
            result.put(key, this.megaBit2bit(value, key));
        } else if (this.isMegaBit2Byte(value)) {
            result.put(key, this.megaBit2Byte(value, key));
        } else if (this.isPercentToRatioFunction(value)) {
            result.put(key, this.percent2Ratio(value, key));
        } else if (this.isMegaHertz2HertzFunction(value)) {
            result.put(key, this.megaHertz2Hertz(value, key));
        } else if (this.isMebiByte2ByteFunction(value)) {
            result.put(key, this.mebiByte2Byte(value, key));
        } else if (this.isMilliVolt2VoltFunction(value)) {
            result.put(key, this.milliVolt2Volt(value, key));
        } else if (this.isBooleanFunction(value)) {
            result.put(key, this.booleanFunction(value, key));
        } else if (this.isLegacyLedStatusFunction(value)) {
            this.computationFunctions.put(key, this::legacyLedStatus);
        } else if (this.isLegacyIntrusionStatusFunction(value)) {
            result.put(key, this.legacyIntrusionStatus(value, key));
        } else if (this.isLegacyPredictedFailureFunction(value)) {
            result.put(key, this.legacyPredictedFailure(value, key));
        } else if (this.islegacyNeedsCleaningFunction(value)) {
            result.put(key, this.legacyNeedsCleaning(value, key));
        } else if (this.isLegacyLinkStatusFunction(value)) {
            result.put(key, this.legacyLinkStatusFunction(value, key));
        } else if (this.isLegacyFullDuplex(value)) {
            result.put(key, this.legacyFullDuplex(value, key));
        } else if (this.isLookupFunction(value)) {
            result.put(key, this.lookup(value, key));
        } else if (this.isComputePowerShareRatioFunction(value)) {
            result.put(String.format("__%s.raw_power_share", key), this.computePowerShareRatio(value, key));
        } else if (this.isLegacyPowerSupplyUtilization(value)) {
            this.computationFunctions.put(key, this::legacyPowerSupplyUtilization);
        } else if (this.isFakeCounterFunction(value)) {
            this.computationFunctions.put(key, this::fakeCounter);
        } else if (this.isRateFunction(value)) {
            this.computationFunctions.put(key, this::rate);
        } else if (this.containsColumnReferences(value)) {
            result.put(key, this.replaceColumnReferences(value, key));
        } else if (value.contains("$index")) {
            result.put(key, this.replaceIndexReferences(value));
        } else {
            result.put(key, value);
        }
    }

    private String lookup(String functionCode, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(functionCode);
        if (functionArguments.size() != 4) {
            log.error("Hostname {} - Lookup should contain exactly 4 arguments (detected {}) in lookup function {}. As a result, {} cannot be updated.", this.jobInfo.getHostname(), functionArguments.size(), functionCode, key);
            return null;
        }
        String monitorType = this.extractColumnValueOrTextValue(functionArguments.get(0), key);
        if (monitorType.isEmpty()) {
            log.error("Hostname {} - Unable to extract the 1st argument value passed to the lookup function. As a result, {} cannot be updated.", (Object)this.jobInfo.getHostname(), (Object)key);
            return null;
        }
        String attributeValueToExtract = this.extractColumnValueOrTextValue(functionArguments.get(1), key);
        if (attributeValueToExtract.isEmpty()) {
            log.error("Hostname {} - Unable to extract the 2nd argument value passed to the lookup function. As a result, {} cannot be updated.", (Object)this.jobInfo.getHostname(), (Object)key);
            return null;
        }
        String lookupAttributeKey = this.extractColumnValueOrTextValue(functionArguments.get(2), key);
        if (lookupAttributeKey.isEmpty()) {
            log.error("Hostname {} - Unable to extract the 3rd argument value passed to the lookup function. As a result, {} cannot be updated.", (Object)this.jobInfo.getHostname(), (Object)key);
            return null;
        }
        String lookupAttributeValue = this.extractColumnValueOrTextValue(functionArguments.get(3), key);
        if (lookupAttributeValue.isEmpty()) {
            log.error("Hostname {} - Unable to extract the 4th argument value passed to the lookup function. As a result, {} cannot be updated.", (Object)this.jobInfo.getHostname(), (Object)key);
            return null;
        }
        Map<String, Monitor> typedMonitors = this.telemetryManager.findMonitorsByType(monitorType);
        if (typedMonitors == null) {
            log.error("Hostname {} - No monitors found of type {}. Cannot set {}.", this.jobInfo.getHostname(), monitorType, key);
            return null;
        }
        Stream<Monitor> monitors = typedMonitors.values().stream().filter(monitor -> lookupAttributeValue.equals(monitor.getAttributes().get(lookupAttributeKey)));
        Monitor monitor2 = monitors.findFirst().orElse(null);
        if (monitor2 == null) {
            log.error("Hostname {} - No monitor found matching attribute {} with value {}.As a result, {} cannot be updated.", this.jobInfo.getHostname(), lookupAttributeKey, lookupAttributeValue, key);
            return null;
        }
        return monitor2.getAttributes().get(attributeValueToExtract);
    }

    private String legacyPowerSupplyUtilization(KeyValuePair keyValuePair, Monitor monitor) {
        Double result;
        NumberMetric metric;
        String key = keyValuePair.getKey();
        String value = keyValuePair.getValue();
        String hostname = this.jobInfo.getHostname();
        try {
            metric = monitor.getMetric("hw.power_supply.limit", NumberMetric.class);
        }
        catch (Exception e) {
            return "";
        }
        if (metric == null) {
            return "";
        }
        Double powerLimit = metric.getValue();
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extracted = functionArguments.get(0);
        Optional<Double> maybePower = this.extractDoubleValue(extracted, key);
        if (maybePower.isPresent() && (result = MathOperationsHelper.divide(key, maybePower.get(), powerLimit, hostname)) != null) {
            return result.toString();
        }
        return "";
    }

    private String fakeCounter(KeyValuePair keyValuePair, Monitor monitor) {
        String hostname = this.jobInfo.getHostname();
        String metricName = keyValuePair.getKey();
        String functionArgument = FunctionArgumentsExtractor.extractArguments(keyValuePair.getValue()).get(0);
        Optional<Double> maybeMetricRateValue = this.extractDoubleValue(functionArgument, metricName);
        if (maybeMetricRateValue.isEmpty()) {
            log.warn("Hostname {} - Unable to extract the 1st argument value passed to the fakeCounter function.As a result, {} cannot be updated.", (Object)hostname, (Object)metricName);
            return "";
        }
        String metricRateName = String.format("__%s.fake_counter_from", metricName);
        MetricFactory metricFactory = new MetricFactory(hostname);
        Double rawValue = maybeMetricRateValue.get();
        metricFactory.collectNumberMetric(monitor, metricRateName, rawValue, (Long)this.collectTime);
        Double collectTimePrevious = CollectHelper.getNumberMetricCollectTime(monitor, metricRateName, true);
        Double deltaTimeMs = MathOperationsHelper.subtract(metricRateName, Double.valueOf(this.collectTime), collectTimePrevious, hostname);
        Double deltaTime = deltaTimeMs != null ? Double.valueOf(deltaTimeMs / 1000.0) : null;
        Double usageDelta = MathOperationsHelper.multiply(metricRateName, rawValue, deltaTime, hostname);
        if (usageDelta != null) {
            Double counter = usageDelta;
            Double previousCounter = CollectHelper.getNumberMetricValue(monitor, metricName, true);
            if (previousCounter != null) {
                counter = counter + previousCounter;
            }
            return counter.toString();
        }
        log.debug("Hostname {} - Cannot calculate fake counter {} for monitor {}. Current raw value {} - Current time {} - Previous time {}.", hostname, metricName, monitor.getId(), rawValue, this.collectTime, collectTimePrevious);
        return "";
    }

    private String rate(KeyValuePair keyValuePair, Monitor monitor) {
        String hostname = this.jobInfo.getHostname();
        String metricName = keyValuePair.getKey();
        String functionArgument = FunctionArgumentsExtractor.extractArguments(keyValuePair.getValue()).get(0);
        Optional<Double> maybeMetricCounterValue = this.extractDoubleValue(functionArgument, metricName);
        if (maybeMetricCounterValue.isEmpty()) {
            log.warn("Hostname {} - Unable to extract the 1st argument value passed to the rate function.As a result, {} cannot be updated.", (Object)hostname, (Object)metricName);
            return "";
        }
        String metricRateName = String.format("__%s.rate_from", metricName);
        MetricFactory metricFactory = new MetricFactory(hostname);
        Double rawValue = maybeMetricCounterValue.get();
        metricFactory.collectNumberMetric(monitor, metricRateName, rawValue, (Long)this.collectTime);
        Double collectTimePrevious = CollectHelper.getNumberMetricCollectTime(monitor, metricRateName, true);
        Double deltaTimeMs = MathOperationsHelper.subtract(metricRateName, Double.valueOf(this.collectTime), collectTimePrevious, hostname);
        Double deltaTime = deltaTimeMs != null ? Double.valueOf(deltaTimeMs / 1000.0) : null;
        Double previousValue = CollectHelper.getNumberMetricValue(monitor, metricRateName, true);
        Double deltaCounter = MathOperationsHelper.subtract(metricRateName, rawValue, previousValue, hostname);
        Double result = MathOperationsHelper.divide(metricName, deltaCounter, deltaTime, hostname);
        if (result != null) {
            return result.toString();
        }
        log.debug("Hostname {} - Cannot create rate {} for monitor {}. Current raw value {} - Current time {} - Previous time {}.", hostname, metricName, monitor.getId(), rawValue, this.collectTime, collectTimePrevious);
        return "";
    }

    private boolean isFakeCounterFunction(String value) {
        return FAKE_COUNTER_PATTERN.matcher(value).find();
    }

    private boolean isLegacyPowerSupplyUtilization(String value) {
        return LEGACY_POWER_SUPPLY_UTILIZATION_PATTERN.matcher(value).find();
    }

    private boolean isLookupFunction(String value) {
        return LOOKUP_PATTERN.matcher(value).find();
    }

    private boolean isRateFunction(String value) {
        return RATE_PATTERN.matcher(value).find();
    }

    String megaBit2bit(String value, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        Optional<Double> maybeDoubleValue = this.extractDoubleValue(functionArguments.get(0), key);
        if (maybeDoubleValue.isPresent()) {
            return this.multiplyValueByFactor(maybeDoubleValue.get(), 1000000.0);
        }
        return "";
    }

    private String megaBit2Byte(String value, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        Optional<Double> maybeDoubleValue = this.extractDoubleValue(functionArguments.get(0), key);
        if (maybeDoubleValue.isPresent()) {
            return this.multiplyValueByFactor(maybeDoubleValue.get(), 125000.0);
        }
        return "";
    }

    private boolean isMegaBit2Byte(String value) {
        return MEGABIT_2_BYTE_PATTERN.matcher(value).find();
    }

    private boolean isMegaBit2Bit(String value) {
        return MEGABIT_2_BIT_PATTERN.matcher(value).find();
    }

    private String legacyFullDuplex(String value, String key) {
        Optional<DuplexMode> maybeDuplexMode;
        String extracted;
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extractedValue = extracted = functionArguments.get(0);
        if (this.isColumnExtraction(extracted)) {
            extractedValue = this.extractColumnValue(extracted, key);
        }
        if ((maybeDuplexMode = DuplexMode.interpret(extractedValue)).isPresent()) {
            return String.valueOf(maybeDuplexMode.get().getNumericValue());
        }
        log.debug(INVALID_VALUE, this.jobInfo.getHostname(), extractedValue, key);
        return null;
    }

    private boolean isLegacyFullDuplex(String value) {
        return LEGACY_FULL_DUPLEX_PATTERN.matcher(value).find();
    }

    private String legacyLinkStatusFunction(String value, String key) {
        Optional<LinkStatus> maybeLinkStatus;
        String extracted;
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extractedValue = extracted = functionArguments.get(0);
        if (this.isColumnExtraction(extracted)) {
            extractedValue = this.extractColumnValue(extracted, key);
        }
        if ((maybeLinkStatus = LinkStatus.interpret(extractedValue)).isPresent()) {
            return String.valueOf(maybeLinkStatus.get().getNumericValue());
        }
        log.debug(INVALID_VALUE, this.jobInfo.getHostname(), extractedValue, key);
        return null;
    }

    private boolean isLegacyLinkStatusFunction(String value) {
        return LEGACY_LINK_STATUS_PATTERN.matcher(value).find();
    }

    private String computePowerShareRatio(String value, String key) {
        String functionArgument = FunctionArgumentsExtractor.extractArguments(value).get(0);
        Optional<Double> maybeRawPowerRatioValue = this.extractDoubleValue(functionArgument, key);
        if (maybeRawPowerRatioValue.isEmpty()) {
            log.warn("Hostname {} - Unable to extract the 1st argument value passed to the computePowerRatio function.As a result, {} cannot be updated.", (Object)this.jobInfo.getHostname(), (Object)key);
            return "";
        }
        return maybeRawPowerRatioValue.get().toString();
    }

    private boolean isComputePowerShareRatioFunction(String value) {
        return COMPUTE_POWER_SHARE_RATIO_PATTERN.matcher(value).find();
    }

    private String legacyNeedsCleaning(String value, String key) {
        Optional<NeedsCleaning> maybeNeedsCleaning;
        String extracted;
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extractedValue = extracted = functionArguments.get(0);
        if (this.isColumnExtraction(extracted)) {
            extractedValue = this.extractColumnValue(extracted, key);
        }
        if ((maybeNeedsCleaning = NeedsCleaning.interpret(extractedValue)).isPresent()) {
            return String.valueOf(maybeNeedsCleaning.get().getNumericValue());
        }
        log.debug(INVALID_VALUE, this.jobInfo.getHostname(), extractedValue, key);
        return null;
    }

    private boolean islegacyNeedsCleaningFunction(String value) {
        return LEGACY_NEEDS_CLEANING_PATTERN.matcher(value).find();
    }

    private String legacyPredictedFailure(String value, String key) {
        Optional<PredictedFailure> maybePredictedFailure;
        String extracted;
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extractedValue = extracted = functionArguments.get(0);
        if (this.isColumnExtraction(extracted)) {
            extractedValue = this.extractColumnValue(extracted, key);
        }
        if ((maybePredictedFailure = PredictedFailure.interpret(extractedValue)).isPresent()) {
            return String.valueOf(maybePredictedFailure.get().getNumericValue());
        }
        log.debug(INVALID_VALUE, this.jobInfo.getHostname(), extractedValue, key);
        return null;
    }

    private boolean isLegacyPredictedFailureFunction(String value) {
        return LEGACY_PREDICTED_FAILURE_PATTERN.matcher(value).find();
    }

    private String legacyIntrusionStatus(String value, String key) {
        Optional<IntrusionStatus> maybeIntrusionStatus;
        String extracted;
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extractedValue = extracted = functionArguments.get(0);
        if (this.isColumnExtraction(extracted)) {
            extractedValue = this.extractColumnValue(extracted, key);
        }
        if ((maybeIntrusionStatus = IntrusionStatus.interpret(extractedValue)).isPresent()) {
            return String.valueOf(maybeIntrusionStatus.get().getNumericValue());
        }
        log.debug(INVALID_VALUE, this.jobInfo.getHostname(), extractedValue, key);
        return null;
    }

    private boolean isLegacyIntrusionStatusFunction(String value) {
        return LEGACY_INTRUSION_STATUS_PATTERN.matcher(value).find();
    }

    private String legacyLedStatus(KeyValuePair keyValuePair, Monitor monitor) {
        Map<String, String> monitorAttributes = monitor.getAttributes();
        String extractedArgument = FunctionArgumentsExtractor.extractArguments(keyValuePair.value).get(0);
        String extractedValue = this.extractColumnValueOrTextValue(extractedArgument, keyValuePair.getKey());
        String status = null;
        switch (extractedValue.toLowerCase()) {
            case "on": {
                status = monitorAttributes.get("__on_status");
                break;
            }
            case "off": {
                status = monitorAttributes.get("__off_status");
                break;
            }
            case "blinking": {
                status = monitorAttributes.get("__blinking_status");
                break;
            }
            default: {
                status = "";
            }
        }
        return status != null ? status.toLowerCase() : "";
    }

    private boolean isLegacyLedStatusFunction(String value) {
        return LEGACY_LED_STATUS_PATTERN.matcher(value).find();
    }

    private String booleanFunction(String value, String key) {
        String extracted;
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        String extractedValue = extracted = functionArguments.get(0);
        if (this.isColumnExtraction(extracted)) {
            extractedValue = this.extractColumnValue(extracted, key);
        }
        if (ONE.equals(extractedValue) || TRUE.equalsIgnoreCase(extractedValue)) {
            return ONE;
        }
        return ZERO;
    }

    private boolean isBooleanFunction(String value) {
        return BOOLEAN_PATTERN.matcher(value).find();
    }

    private String mebiByte2Byte(String value, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        Optional<Double> maybeDoubleValue = this.extractDoubleValue(functionArguments.get(0), key);
        if (maybeDoubleValue.isPresent()) {
            return this.multiplyValueByFactor(maybeDoubleValue.get(), 1048576.0);
        }
        return "";
    }

    private boolean isMebiByte2ByteFunction(String value) {
        return MEBIBYTE_2_BYTE_PATTERN.matcher(value).find();
    }

    private String milliVolt2Volt(String value, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        Optional<Double> maybeDoubleValue = this.extractDoubleValue(functionArguments.get(0), key);
        if (maybeDoubleValue.isPresent()) {
            return this.multiplyValueByFactor(maybeDoubleValue.get(), 0.001);
        }
        return "";
    }

    private boolean isMilliVolt2VoltFunction(String value) {
        return MILLIVOLT_2_VOLT_PATTERN.matcher(value).find();
    }

    private String megaHertz2Hertz(String value, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        Optional<Double> maybeDoubleValue = this.extractDoubleValue(functionArguments.get(0), key);
        if (maybeDoubleValue.isPresent()) {
            return this.multiplyValueByFactor(maybeDoubleValue.get(), 1000000.0);
        }
        return "";
    }

    private boolean isMegaHertz2HertzFunction(String value) {
        return MEGAHERTZ_2_HERTZ_PATTERN.matcher(value).find();
    }

    private String percent2Ratio(String value, String key) {
        List<String> functionArguments = FunctionArgumentsExtractor.extractArguments(value);
        Optional<Double> maybeDoubleValue = this.extractDoubleValue(functionArguments.get(0), key);
        if (maybeDoubleValue.isPresent()) {
            return this.multiplyValueByFactor(maybeDoubleValue.get(), 0.01);
        }
        return "";
    }

    private boolean isPercentToRatioFunction(String value) {
        return PERCENT_2_RATIO_PATTERN.matcher(value).find();
    }

    private String executeAwkScript(String value, String key) {
        String awkTemplate;
        ClientsExecutor clientsExecutor = new ClientsExecutor();
        String function = value.trim().replace("${awk::", "").replace("}", "");
        ClassPathResource resource = new ClassPathResource("internalAwk.awk");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
            awkTemplate = reader.lines().collect(Collectors.joining("\n")).replace("SCRIPT_PLACEHOLDER", function);
        }
        catch (Exception e) {
            return "";
        }
        try {
            return clientsExecutor.executeAwkScript(awkTemplate, String.join((CharSequence)";", this.row));
        }
        catch (Exception e) {
            log.error("Hostname {} - Error while running awk function {} for parameter {}.", this.jobInfo.getHostname(), value, key);
            log.debug("Hostname {} - Exception: {}", (Object)this.jobInfo.getHostname(), (Object)e);
            return "";
        }
    }

    private Optional<Double> extractDoubleValue(String value, String key) {
        try {
            return Optional.of(Double.parseDouble(this.extractColumnValueOrTextValue(value, key)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private String multiplyValueByFactor(Double value, double factor) {
        return Double.toString(value * factor);
    }

    private String extractColumnValue(String reference, String key) {
        Matcher matcher = this.getStringRegexMatcher(reference);
        matcher.find();
        int columnIndex = Integer.parseInt(matcher.group(1)) - 1;
        int rowSize = this.row.size();
        if (columnIndex >= 0 && columnIndex < rowSize) {
            String result = this.row.get(columnIndex);
            if (result != null) {
                return result;
            }
            log.warn("Hostname {} - Extract Column Value: value is null for column number {} in the row. Unable to fetch the value for attribute key {}. Source: {} - Row: {} - Monitor type: {}.", this.jobInfo.getHostname(), columnIndex, key, this.mapping.getSource(), this.row, this.jobInfo.getMonitorType());
        } else {
            log.warn("Hostname {} - Extract Column Value: column number {} is out of bounds for source {} with row size {}. Unable to fetch the value for attribute key {}. Row: {}, Monitor type: {}.", this.jobInfo.getHostname(), columnIndex, this.mapping.getSource(), rowSize, key, this.row, this.jobInfo.getMonitorType());
        }
        return "";
    }

    private String replaceColumnReferences(String value, String key) {
        String replacedValue = this.getColumnReferenceMatcher(value).replaceAll(match -> this.getColumnValue((MatchResult)match, key));
        if (replacedValue.contains("$index")) {
            replacedValue = this.replaceIndexReferences(replacedValue);
        }
        return replacedValue;
    }

    private String replaceIndexReferences(String value) {
        return value.replace("$index", String.valueOf(this.indexCounter));
    }

    private String getColumnValue(MatchResult match, String key) {
        int columnIndex = Integer.parseInt(match.group(1)) - 1;
        int rowSize = this.row.size();
        if (columnIndex >= 0 && columnIndex < rowSize) {
            String columnValue = this.row.get(columnIndex);
            if (columnValue != null) {
                return Matcher.quoteReplacement(columnValue);
            }
            log.warn("Hostname {} - Get Column Value: value is null for column number {} in the row. Unable to fetch the value for attribute key {}. Source: {} - Row: {} - Monitor type: {}.", this.jobInfo.getHostname(), columnIndex, key, this.mapping.getSource(), this.row, this.jobInfo.getMonitorType());
        } else {
            log.warn("Hostname {} - Get Column Value: column number {} is out of bounds for source {} with row size {}. Unable to fetch the value for attribute key {}. Row: {}, Monitor type: {}.", this.jobInfo.getHostname(), columnIndex, this.mapping.getSource(), rowSize, key, this.row, this.jobInfo.getMonitorType());
        }
        return "";
    }

    private boolean isAwkScript(String value) {
        return AWK_SCRIPT_PATTERN.matcher(value).find();
    }

    private boolean isColumnExtraction(String value) {
        return this.getStringRegexMatcher(value).find();
    }

    private boolean containsColumnReferences(String value) {
        return this.getColumnReferenceMatcher(value).find();
    }

    private Matcher getStringRegexMatcher(String value) {
        return MetricsHubConstants.COLUMN_PATTERN.matcher(value);
    }

    private Matcher getColumnReferenceMatcher(String value) {
        return MetricsHubConstants.COLUMN_REFERENCE_PATTERN.matcher(value);
    }

    private String extractColumnValueOrTextValue(String columnRefOrValue, String key) {
        if (this.isColumnExtraction(columnRefOrValue)) {
            return this.extractColumnValue(columnRefOrValue, key);
        }
        return columnRefOrValue;
    }

    public Resource interpretMappingResource() {
        MappingResource mappingResource = this.mapping.getResource();
        if (mappingResource != null && mappingResource.hasType()) {
            return Resource.builder().type(this.interpretNonContextMapping(Map.of("type", mappingResource.getType())).get("type")).attributes(this.interpretNonContextMapping(mappingResource.getAttributes())).build();
        }
        return null;
    }

    public Map<String, String> interpretContextMappingAttributes(Monitor monitor) {
        return this.interpretContextKeyValuePairs(monitor, this.mapping.getAttributes());
    }

    public Map<String, String> interpretContextMappingMetrics(Monitor monitor) {
        return this.interpretContextKeyValuePairs(monitor, this.mapping.getMetrics());
    }

    public Map<String, String> interpretContextMappingConditionalCollection(Monitor monitor) {
        return this.interpretContextKeyValuePairs(monitor, this.mapping.getConditionalCollection());
    }

    public Map<String, String> interpretContextMappingLegacyTextParameters(Monitor monitor) {
        return this.interpretContextKeyValuePairs(monitor, this.mapping.getLegacyTextParameters());
    }

    private Map<String, String> interpretContextKeyValuePairs(Monitor monitor, Map<String, String> keyValuePairs) {
        if (keyValuePairs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        this.computationFunctions.entrySet().forEach(entry -> {
            String attributeKey = (String)entry.getKey();
            String value = (String)keyValuePairs.get(attributeKey);
            String attributeValue = SourceUpdaterProcessor.replaceSourceReferenceContent(value, this.telemetryManager, this.jobInfo.getConnectorId(), "mapping", attributeKey);
            result.put(attributeKey, (String)((BiFunction)entry.getValue()).apply(new KeyValuePair(attributeKey, attributeValue), monitor));
        });
        this.computationFunctions.clear();
        return result;
    }

    @Generated
    private static Map<String, BiFunction<KeyValuePair, Monitor, String>> $default$computationFunctions() {
        return new HashMap<String, BiFunction<KeyValuePair, Monitor, String>>();
    }

    @Generated
    public static MappingProcessorBuilder builder() {
        return new MappingProcessorBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public Mapping getMapping() {
        return this.mapping;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getCollectTime() {
        return this.collectTime;
    }

    @Generated
    public List<String> getRow() {
        return this.row;
    }

    @Generated
    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    @Generated
    public int getIndexCounter() {
        return this.indexCounter;
    }

    @Generated
    public Map<String, BiFunction<KeyValuePair, Monitor, String>> getComputationFunctions() {
        return this.computationFunctions;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCollectTime(long collectTime) {
        this.collectTime = collectTime;
    }

    @Generated
    public void setRow(List<String> row) {
        this.row = row;
    }

    @Generated
    public void setJobInfo(JobInfo jobInfo) {
        this.jobInfo = jobInfo;
    }

    @Generated
    public void setIndexCounter(int indexCounter) {
        this.indexCounter = indexCounter;
    }

    @Generated
    public void setComputationFunctions(Map<String, BiFunction<KeyValuePair, Monitor, String>> computationFunctions) {
        this.computationFunctions = computationFunctions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingProcessor)) {
            return false;
        }
        MappingProcessor other = (MappingProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCollectTime() != other.getCollectTime()) {
            return false;
        }
        if (this.getIndexCounter() != other.getIndexCounter()) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        Mapping this$mapping = this.getMapping();
        Mapping other$mapping = other.getMapping();
        if (this$mapping == null ? other$mapping != null : !((Object)this$mapping).equals(other$mapping)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$row = this.getRow();
        List<String> other$row = other.getRow();
        if (this$row == null ? other$row != null : !((Object)this$row).equals(other$row)) {
            return false;
        }
        JobInfo this$jobInfo = this.getJobInfo();
        JobInfo other$jobInfo = other.getJobInfo();
        if (this$jobInfo == null ? other$jobInfo != null : !((Object)this$jobInfo).equals(other$jobInfo)) {
            return false;
        }
        Map<String, BiFunction<KeyValuePair, Monitor, String>> this$computationFunctions = this.getComputationFunctions();
        Map<String, BiFunction<KeyValuePair, Monitor, String>> other$computationFunctions = other.getComputationFunctions();
        return !(this$computationFunctions == null ? other$computationFunctions != null : !((Object)this$computationFunctions).equals(other$computationFunctions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MappingProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $collectTime = this.getCollectTime();
        result = result * 59 + (int)($collectTime >>> 32 ^ $collectTime);
        result = result * 59 + this.getIndexCounter();
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        Mapping $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : ((Object)$mapping).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : ((Object)$row).hashCode());
        JobInfo $jobInfo = this.getJobInfo();
        result = result * 59 + ($jobInfo == null ? 43 : ((Object)$jobInfo).hashCode());
        Map<String, BiFunction<KeyValuePair, Monitor, String>> $computationFunctions = this.getComputationFunctions();
        result = result * 59 + ($computationFunctions == null ? 43 : ((Object)$computationFunctions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MappingProcessor(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", mapping=" + String.valueOf(this.getMapping()) + ", id=" + this.getId() + ", collectTime=" + this.getCollectTime() + ", row=" + String.valueOf(this.getRow()) + ", jobInfo=" + String.valueOf(this.getJobInfo()) + ", indexCounter=" + this.getIndexCounter() + ", computationFunctions=" + String.valueOf(this.getComputationFunctions()) + ")";
    }

    @Generated
    public MappingProcessor(TelemetryManager telemetryManager, Mapping mapping, String id, long collectTime, List<String> row, JobInfo jobInfo, int indexCounter, Map<String, BiFunction<KeyValuePair, Monitor, String>> computationFunctions) {
        this.telemetryManager = telemetryManager;
        this.mapping = mapping;
        this.id = id;
        this.collectTime = collectTime;
        this.row = row;
        this.jobInfo = jobInfo;
        this.indexCounter = indexCounter;
        this.computationFunctions = computationFunctions;
    }

    @Generated
    public MappingProcessor() {
        this.computationFunctions = MappingProcessor.$default$computationFunctions();
    }

    static class KeyValuePair {
        String key;
        String value;

        @Generated
        KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Generated
        public static KeyValuePairBuilder builder() {
            return new KeyValuePairBuilder();
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValuePair)) {
                return false;
            }
            KeyValuePair other = (KeyValuePair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeyValuePair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MappingProcessor.KeyValuePair(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }

        @Generated
        public static class KeyValuePairBuilder {
            @Generated
            private String key;
            @Generated
            private String value;

            @Generated
            KeyValuePairBuilder() {
            }

            @Generated
            public KeyValuePairBuilder key(String key) {
                this.key = key;
                return this;
            }

            @Generated
            public KeyValuePairBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public KeyValuePair build() {
                return new KeyValuePair(this.key, this.value);
            }

            @Generated
            public String toString() {
                return "MappingProcessor.KeyValuePair.KeyValuePairBuilder(key=" + this.key + ", value=" + this.value + ")";
            }
        }
    }

    @Generated
    public static class MappingProcessorBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Mapping mapping;
        @Generated
        private String id;
        @Generated
        private long collectTime;
        @Generated
        private List<String> row;
        @Generated
        private JobInfo jobInfo;
        @Generated
        private int indexCounter;
        @Generated
        private boolean computationFunctions$set;
        @Generated
        private Map<String, BiFunction<KeyValuePair, Monitor, String>> computationFunctions$value;

        @Generated
        MappingProcessorBuilder() {
        }

        @Generated
        public MappingProcessorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public MappingProcessorBuilder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        @Generated
        public MappingProcessorBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public MappingProcessorBuilder collectTime(long collectTime) {
            this.collectTime = collectTime;
            return this;
        }

        @Generated
        public MappingProcessorBuilder row(List<String> row) {
            this.row = row;
            return this;
        }

        @Generated
        public MappingProcessorBuilder jobInfo(JobInfo jobInfo) {
            this.jobInfo = jobInfo;
            return this;
        }

        @Generated
        public MappingProcessorBuilder indexCounter(int indexCounter) {
            this.indexCounter = indexCounter;
            return this;
        }

        @Generated
        public MappingProcessorBuilder computationFunctions(Map<String, BiFunction<KeyValuePair, Monitor, String>> computationFunctions) {
            this.computationFunctions$value = computationFunctions;
            this.computationFunctions$set = true;
            return this;
        }

        @Generated
        public MappingProcessor build() {
            Map<String, BiFunction<KeyValuePair, Monitor, String>> computationFunctions$value = this.computationFunctions$value;
            if (!this.computationFunctions$set) {
                computationFunctions$value = MappingProcessor.$default$computationFunctions();
            }
            return new MappingProcessor(this.telemetryManager, this.mapping, this.id, this.collectTime, this.row, this.jobInfo, this.indexCounter, computationFunctions$value);
        }

        @Generated
        public String toString() {
            return "MappingProcessor.MappingProcessorBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", mapping=" + String.valueOf(this.mapping) + ", id=" + this.id + ", collectTime=" + this.collectTime + ", row=" + String.valueOf(this.row) + ", jobInfo=" + String.valueOf(this.jobInfo) + ", indexCounter=" + this.indexCounter + ", computationFunctions$value=" + String.valueOf(this.computationFunctions$value) + ")";
        }
    }
}

