/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathOperationsHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MathOperationsHelper.class);

    public static Double subtract(String metricName, Double minuend, Double subtrahend, String hostname) {
        if (minuend == null || subtrahend == null) {
            return null;
        }
        double result = minuend - subtrahend;
        if (result < 0.0) {
            log.warn("Hostname {} - Suspicious negative value ({} - {}) = {} for metric {}.", hostname, minuend, subtrahend, result, metricName);
            return null;
        }
        return result;
    }

    public static Double divide(String metricName, Double dividend, Double divisor, String hostname) {
        if (dividend == null || divisor == null) {
            return null;
        }
        if (divisor == 0.0) {
            log.debug("Hostname {} - Couldn't compute ({} / {}) for metric {}. Division by zero is not allowed.", hostname, dividend, divisor, metricName);
            return null;
        }
        double result = dividend / divisor;
        if (result < 0.0) {
            log.warn("Hostname {} - Suspicious negative value ({} / {}) = {} for metric {}.", hostname, dividend, divisor, result, metricName);
            return null;
        }
        return result;
    }

    public static Double multiply(String metricName, Double multiplier, Double multiplicand, String hostname) {
        if (multiplier == null || multiplicand == null) {
            return null;
        }
        double result = multiplier * multiplicand;
        if (result < 0.0) {
            log.warn("Hostname {} - Suspicious negative value ({} * {}) = {} for metric {}.", hostname, multiplier, multiplicand, result, metricName);
            return null;
        }
        return result;
    }

    public static Double rate(String metricName, Double value, Double previousValue, Double collectTime, Double previousCollectTime, String hostname) {
        return MathOperationsHelper.divide(metricName, MathOperationsHelper.subtract(metricName, value, previousValue, hostname), MathOperationsHelper.subtract(metricName, collectTime, previousCollectTime, hostname), hostname);
    }

    public static Double min(Double operandOne, Double operandTwo) {
        if (operandOne == null) {
            return operandTwo;
        }
        if (operandTwo == null) {
            return operandOne;
        }
        return Math.min(operandOne, operandTwo);
    }

    @Generated
    private MathOperationsHelper() {
    }
}

