/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PslUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PslUtils.class);
    private static final String SPECIAL_CHARACTERS = "^$.*+?[]\\";
    private static final String BACKSLASH_B = "\\b";
    private static final String DOT_PLUS = ".+";
    private static final String DOT = ".";
    private static final char BACKSLASH_CHAR = '\\';
    private static final char OPENING_PARENTHESIS_CHAR = '(';
    private static final char CLOSING_PARENTHESIS_CHAR = ')';
    private static final char PIPE_CHAR = '|';
    private static final char OPENING_CURLY_BRACKET_CHAR = '{';
    private static final char CLOSING_CURLY_BRACKET_CHAR = '}';
    private static final char OPENING_SQUARE_BRACKET_CHAR = '[';
    private static final char CLOSING_SQUARE_BRACKET_CHAR = ']';
    private static final char LOWER_THAN_CHAR = '<';
    private static final char GREATER_THAN_CHAR = '>';

    private PslUtils() {
    }

    public static String psl2JavaRegex(String pslRegex) {
        if (pslRegex == null || pslRegex.isEmpty()) {
            return "";
        }
        if (DOT.equals(pslRegex)) {
            return DOT_PLUS;
        }
        StringBuilder javaRegex = new StringBuilder();
        boolean inRange = false;
        for (int i = 0; i < pslRegex.length(); ++i) {
            char c = pslRegex.charAt(i);
            if (c == '\\' && i < pslRegex.length() - 1) {
                i = PslUtils.handleBackSlash(pslRegex, inRange, i, javaRegex);
                continue;
            }
            if (c == '(' || c == ')' || c == '|' || c == '{' || c == '}') {
                javaRegex.append('\\').append(c);
                continue;
            }
            if (c == '[') {
                javaRegex.append(c);
                inRange = true;
                continue;
            }
            if (c == ']') {
                javaRegex.append(c);
                inRange = false;
                continue;
            }
            javaRegex.append(c);
        }
        return javaRegex.toString();
    }

    private static int handleBackSlash(String pslRegex, boolean inRange, int index, StringBuilder javaRegex) {
        int result = index;
        if (inRange) {
            javaRegex.append("\\\\");
        } else {
            char nextChar = pslRegex.charAt(index + 1);
            if (nextChar == '<' || nextChar == '>') {
                javaRegex.append(BACKSLASH_B);
                ++result;
            } else if (SPECIAL_CHARACTERS.indexOf(nextChar) > -1) {
                javaRegex.append('\\').append(nextChar);
                ++result;
            } else {
                javaRegex.append(nextChar);
                ++result;
            }
        }
        return result;
    }

    public static String formatExtendedJSON(@NonNull String row, @NonNull SourceTable tableResult) throws IllegalArgumentException {
        if (row == null) {
            throw new IllegalArgumentException("row is marked non-null but is null");
        }
        if (tableResult == null) {
            throw new IllegalArgumentException("tableResult is marked non-null but is null");
        }
        if (row.isEmpty()) {
            log.error("formatExtendedJSON received Empty row of values. Returning empty string.");
            return "";
        }
        String rawData = tableResult.getRawData();
        if (rawData == null || rawData.isEmpty()) {
            log.error("formatExtendedJSON received Empty SourceTable data {}. Returning empty string.", (Object)tableResult);
            return "";
        }
        StringBuilder jsonContent = new StringBuilder();
        jsonContent.append("{\n\"Entry\":{\n\"Full\":\"").append(row).append("\",\n");
        int i = 1;
        for (String value : row.split(",")) {
            jsonContent.append("\"Column(").append(i).append(")\":\"").append(value).append("\",\n");
            ++i;
        }
        jsonContent.append("\"Value\":").append(rawData).append("\n}\n}");
        return jsonContent.toString();
    }

    public static String nthArgf(String text, String selectColumns, String separators, String resultSeparator) {
        return PslUtils.nthArgCommon(text, selectColumns, separators, resultSeparator, false);
    }

    public static String nthArg(String text, String selectColumns, String separators, String resultSeparator) {
        return PslUtils.nthArgCommon(text, selectColumns, separators, resultSeparator, true);
    }

    private static String nthArgCommon(String text, String selectColumns, String separators, String resultSeparator, boolean isNthArg) {
        String[] textArray;
        if (text == null || selectColumns == null || separators == null || text.isEmpty() || selectColumns.isEmpty() || separators.isEmpty()) {
            return "";
        }
        String separatorsRegExp = String.format("[%s]", separators.replaceAll("([()\\[\\]{}\\\\^\\-$|?*+.])", "\\\\$1"));
        if (isNthArg) {
            text = text.replaceAll(String.format("(%s)(%s)+", separatorsRegExp, separatorsRegExp), "$1");
            text = text.replaceAll("^" + separatorsRegExp + "+", "");
        }
        if (resultSeparator == null) {
            resultSeparator = " ";
        }
        ArrayList<String> finalResult = new ArrayList<String>();
        for (String line : textArray = text.split("\n")) {
            PslUtils.processText(line, selectColumns, separatorsRegExp, resultSeparator, finalResult, isNthArg);
        }
        return finalResult.stream().collect(Collectors.joining(resultSeparator));
    }

    static void processText(String text, String selectColumns, String separatorsRegExp, String resultSeparator, List<String> finalResult, boolean isNthArg) {
        String[] splitText = text.split(separatorsRegExp, -1);
        String[] columnsArray = selectColumns.split(",");
        String result = null;
        for (String columns : columnsArray) {
            int[] columnsRange = PslUtils.getColumnsRange(columns, splitText.length);
            int fromColumnNumber = columnsRange[0];
            int toColumnNumber = columnsRange[1];
            if (fromColumnNumber <= 0 || fromColumnNumber > toColumnNumber) continue;
            result = Arrays.stream(splitText, fromColumnNumber - 1, toColumnNumber).filter(value -> !isNthArg || !value.trim().isEmpty()).collect(Collectors.joining(resultSeparator));
            finalResult.add(result);
        }
    }

    private static int[] getColumnsRange(String columns, int columnCount) {
        int toColumnNumber;
        int fromColumnNumber;
        try {
            int dashIndex = columns.indexOf("-");
            int columnsLength = columns.length();
            if (dashIndex == -1) {
                toColumnNumber = fromColumnNumber = Integer.parseInt(columns);
            } else if (dashIndex == 0) {
                fromColumnNumber = 1;
                toColumnNumber = Integer.parseInt(columns.substring(1));
            } else if (dashIndex == columnsLength - 1) {
                fromColumnNumber = Integer.parseInt(columns.substring(0, columnsLength - 1));
                toColumnNumber = columnCount;
            } else {
                fromColumnNumber = Integer.parseInt(columns.substring(0, dashIndex));
                toColumnNumber = Integer.parseInt(columns.substring(dashIndex + 1));
                if (toColumnNumber > columnCount) {
                    toColumnNumber = columnCount;
                }
            }
            if (fromColumnNumber > columnCount || toColumnNumber > columnCount) {
                log.warn("getColumnRange: Invalid range for a {}-length array: [{}-{}].", columnCount, fromColumnNumber, toColumnNumber);
                fromColumnNumber = 0;
                toColumnNumber = 0;
            }
        }
        catch (NumberFormatException e) {
            log.warn("getColumnRange: Could not determine the range denoted by {}: {}.", (Object)columns, (Object)e.getMessage());
            fromColumnNumber = 0;
            toColumnNumber = 0;
        }
        return new int[]{fromColumnNumber, toColumnNumber};
    }
}

