/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.telemetry;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.metric.IMetricType;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricType;
import org.sentrysoftware.metricshub.engine.connector.model.metric.StateSet;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.engine.telemetry.metric.StateSetMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricFactory.class);
    private static final Pattern METRIC_ATTRIBUTES_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private String hostname;

    public StateSetMetric collectStateSetMetric(Monitor monitor, String metricName, String value, String[] stateSet, long collectTime) {
        StateSetMetric metric = monitor.getMetric(metricName, StateSetMetric.class);
        if (metric == null) {
            StateSetMetric newMetric = StateSetMetric.builder().stateSet(stateSet).name(metricName).collectTime(collectTime).value(value).attributes(MetricFactory.extractAttributesFromMetricName(metricName)).build();
            monitor.addMetric(metricName, newMetric);
            return newMetric;
        }
        metric.setValue(value);
        metric.setCollectTime(collectTime);
        return metric;
    }

    public static Map<String, String> extractAttributesFromMetricName(String metricName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = METRIC_ATTRIBUTES_PATTERN.matcher(metricName);
        if (matcher.find()) {
            String[] keyValuePairs;
            String attributeMap = matcher.group(1);
            for (String pair : keyValuePairs = attributeMap.split(",")) {
                String[] parts = pair.trim().split("=");
                if (parts.length != 2) continue;
                attributes.put(parts[0], parts[1].replace("\"", ""));
            }
        }
        return attributes;
    }

    public NumberMetric collectNumberMetric(Monitor monitor, String name, @NonNull Double value, Long collectTime) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        NumberMetric metric = monitor.getMetric(name, NumberMetric.class);
        if (metric == null) {
            NumberMetric newMetric = NumberMetric.builder().name(name).collectTime(collectTime).value(value).attributes(MetricFactory.extractAttributesFromMetricName(name)).build();
            monitor.addMetric(name, newMetric);
            return newMetric;
        }
        metric.setValue(value);
        metric.setCollectTime(collectTime);
        return metric;
    }

    public NumberMetric collectNumberMetric(Monitor monitor, String name, @NonNull String value, Long collectTime) {
        if (value == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        try {
            return this.collectNumberMetric(monitor, name, Double.parseDouble(value), collectTime);
        }
        catch (Exception e) {
            log.warn("Hostname {} - Cannot parse the {} value '{}' for monitor id {}. {} won't be collected", this.hostname, name, value, monitor.getAttributes().get("id"), name);
            return null;
        }
    }

    public MetricDefinition getMetricDefinitionFromExtractedMetricName(Connector connector, Monitor monitor, String metricName) {
        Map<String, MetricDefinition> metricDefinitionMap = connector.getMetrics();
        String extractedName = MetricFactory.extractName(metricName);
        return metricDefinitionMap.get(extractedName);
    }

    public AbstractMetric collectMetricUsingConnector(Connector connector, Monitor monitor, long strategyTime, String metricName, String metricValue) {
        AbstractMetric metric = null;
        MetricDefinition metricDefinition = this.getMetricDefinitionFromExtractedMetricName(connector, monitor, metricName);
        Map<String, String> metricAttributes = MetricFactory.extractAttributesFromMetricName(metricName);
        boolean hasStateAttribute = this.checkForStateAttribute(metricAttributes);
        if (metricDefinition == null || metricDefinition.getType() instanceof MetricType || hasStateAttribute) {
            metric = this.collectNumberMetric(monitor, metricName, metricValue, (Long)strategyTime);
        } else {
            IMetricType iMetricType = metricDefinition.getType();
            if (iMetricType instanceof StateSet) {
                StateSet stateSetType = (StateSet)iMetricType;
                String[] stateSet = (String[])stateSetType.getSet().stream().toArray(String[]::new);
                metric = this.collectStateSetMetric(monitor, metricName, metricValue, stateSet, strategyTime);
            }
        }
        return metric;
    }

    public static final String extractName(String name) {
        int openBracketPosition = name.indexOf("{");
        if (openBracketPosition >= 0) {
            return name.substring(0, openBracketPosition);
        }
        return name;
    }

    public boolean checkForStateAttribute(Map<String, String> attributes) {
        return attributes.keySet().stream().anyMatch(attributeKey -> attributeKey.equals("state"));
    }

    public void collectMonitorMetrics(String monitorType, Connector connector, Monitor monitor, String connectorId, Map<String, String> metrics, long strategyTime, boolean isDiscovery) {
        for (Map.Entry<String, String> metricEntry : metrics.entrySet()) {
            String name = metricEntry.getKey();
            if (monitor.isMetricDeactivated(name)) continue;
            String value = metricEntry.getValue();
            if (value == null) {
                log.warn("Hostname {} - No value found for metric {}. Skip metric collection on {}. Connector: {}", this.hostname, name, monitorType, connectorId);
                continue;
            }
            AbstractMetric metric = this.collectMetricUsingConnector(connector, monitor, strategyTime, name, value);
            if (!isDiscovery || metric == null) continue;
            metric.setResetMetricTime(true);
        }
    }

    @Generated
    public static MetricFactoryBuilder builder() {
        return new MetricFactoryBuilder();
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricFactory)) {
            return false;
        }
        MetricFactory other = (MetricFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricFactory(hostname=" + this.getHostname() + ")";
    }

    @Generated
    public MetricFactory(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public MetricFactory() {
    }

    @Generated
    public static class MetricFactoryBuilder {
        @Generated
        private String hostname;

        @Generated
        MetricFactoryBuilder() {
        }

        @Generated
        public MetricFactoryBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public MetricFactory build() {
            return new MetricFactory(this.hostname);
        }

        @Generated
        public String toString() {
            return "MetricFactory.MetricFactoryBuilder(hostname=" + this.hostname + ")";
        }
    }
}

