/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.delegate.IPostExecutionService;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.sustainability.CpuPowerEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.DiskControllerPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.FanPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.HostMonitorPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.HostMonitorThermalCalculator;
import org.sentrysoftware.metricshub.hardware.sustainability.MemoryPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.NetworkPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.PhysicalDiskPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.RoboticsPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.TapeDrivePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.sustainability.VmPowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;
import org.sentrysoftware.metricshub.hardware.util.PowerAndEnergyCollectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardwareEnergyPostExecutionService
implements IPostExecutionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HardwareEnergyPostExecutionService.class);
    private static final String HOST_DOES_NOT_CONTAIN_MONITORS = "Host {} does not contain {} monitors";
    private TelemetryManager telemetryManager;

    private void estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType monitorType, String powerMetricName, String energyMetricName, BiFunction<Monitor, TelemetryManager, HardwarePowerAndEnergyEstimator> estimatorGenerator) {
        String monitorTypeKey = monitorType.getKey();
        Map<String, Monitor> sameTypeMonitors = this.telemetryManager.findMonitorsByType(monitorTypeKey);
        if (sameTypeMonitors == null) {
            log.info(HOST_DOES_NOT_CONTAIN_MONITORS, (Object)this.telemetryManager.getHostname(), (Object)monitorTypeKey);
            return;
        }
        sameTypeMonitors.values().stream().filter(monitor -> !HwCollectHelper.isMissing(monitor)).filter(monitor -> this.telemetryManager.isConnectorStatusOk((Monitor)monitor)).filter(monitor -> HwCollectHelper.connectorHasHardwareTag(monitor, this.telemetryManager)).forEach(monitor -> PowerAndEnergyCollectHelper.collectPowerAndEnergy(monitor, powerMetricName, energyMetricName, this.telemetryManager, (HardwarePowerAndEnergyEstimator)estimatorGenerator.apply((Monitor)monitor, this.telemetryManager)));
    }

    private void estimateAndCollectPowerAndEnergyForVm(boolean isPowerEstimated) {
        Map<String, Monitor> vmMonitors = this.telemetryManager.findMonitorsByType(KnownMonitorType.VM.getKey());
        if (vmMonitors == null) {
            log.info(HOST_DOES_NOT_CONTAIN_MONITORS, (Object)this.telemetryManager.getHostname(), (Object)KnownMonitorType.VM.getKey());
            return;
        }
        Map<String, Double> totalPowerSharesByPowerSource = vmMonitors.values().stream().collect(Collectors.toMap(this::getVmPowerSourceMonitorId, HwCollectHelper::getVmPowerShare, Double::sum));
        vmMonitors.values().stream().filter(monitor -> !HwCollectHelper.isMissing(monitor)).filter(monitor -> this.telemetryManager.isConnectorStatusOk((Monitor)monitor)).filter(monitor -> HwCollectHelper.connectorHasHardwareTag(monitor, this.telemetryManager)).forEach(monitor -> PowerAndEnergyCollectHelper.collectPowerAndEnergy(monitor, "hw.power{hw.type=\"vm\"}", "hw.energy{hw.type=\"vm\"}", this.telemetryManager, new VmPowerAndEnergyEstimator((Monitor)monitor, this.telemetryManager, totalPowerSharesByPowerSource, isPowerEstimated)));
    }

    public String getVmPowerSourceMonitorId(Monitor monitor) {
        Monitor parent = this.telemetryManager.findParentMonitor(monitor);
        if (parent != null && parent.getMetric("hw.power{hw.type=\"vm\"}", NumberMetric.class) != null) {
            monitor.addAttribute("__power_source_id", parent.getId());
            return parent.getId();
        }
        Monitor hostMonitor = this.telemetryManager.getEndpointHostMonitor();
        monitor.addAttribute("__power_source_id", hostMonitor.getId());
        return hostMonitor.getId();
    }

    private boolean estimateAndCollectPowerAndEnergyForHost(BiFunction<Monitor, TelemetryManager, HostMonitorPowerAndEnergyEstimator> estimatorGenerator) {
        Monitor hostMonitor = this.telemetryManager.getEndpointHostMonitor();
        if (hostMonitor == null) {
            log.info("Host {} does not exist", (Object)this.telemetryManager.getHostname());
            return false;
        }
        return PowerAndEnergyCollectHelper.collectHostPowerAndEnergy(hostMonitor, this.telemetryManager, estimatorGenerator.apply(hostMonitor, this.telemetryManager));
    }

    @Override
    public void run() {
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.FAN, "hw.power{hw.type=\"fan\"}", "hw.energy{hw.type=\"fan\"}", FanPowerAndEnergyEstimator::new);
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.ROBOTICS, "hw.power{hw.type=\"robotics\"}", "hw.energy{hw.type=\"robotics\"}", RoboticsPowerAndEnergyEstimator::new);
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.TAPE_DRIVE, "hw.power{hw.type=\"tape_drive\"}", "hw.energy{hw.type=\"tape_drive\"}", TapeDrivePowerAndEnergyEstimator::new);
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.DISK_CONTROLLER, "hw.power{hw.type=\"disk_controller\"}", "hw.energy{hw.type=\"disk_controller\"}", DiskControllerPowerAndEnergyEstimator::new);
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.PHYSICAL_DISK, "hw.power{hw.type=\"physical_disk\"}", "hw.energy{hw.type=\"physical_disk\"}", PhysicalDiskPowerAndEnergyEstimator::new);
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.MEMORY, "hw.power{hw.type=\"memory\"}", "hw.energy{hw.type=\"memory\"}", MemoryPowerAndEnergyEstimator::new);
        this.collectNetworkMetrics();
        new HostMonitorThermalCalculator(this.telemetryManager).computeHostTemperatureMetrics();
        this.estimateAndCollectPowerAndEnergyForMonitorType(KnownMonitorType.CPU, "hw.power{hw.type=\"cpu\"}", "hw.energy{hw.type=\"cpu\"}", CpuPowerEstimator::new);
        boolean isPowerMeasured = this.estimateAndCollectPowerAndEnergyForHost(HostMonitorPowerAndEnergyEstimator::new);
        this.estimateAndCollectPowerAndEnergyForVm(isPowerMeasured);
    }

    private void collectNetworkMetrics() {
        String monitorTypeKey = KnownMonitorType.NETWORK.getKey();
        Map<String, Monitor> sameTypeMonitors = this.telemetryManager.findMonitorsByType(monitorTypeKey);
        if (sameTypeMonitors == null) {
            log.info(HOST_DOES_NOT_CONTAIN_MONITORS, (Object)this.telemetryManager.getHostname(), (Object)monitorTypeKey);
            return;
        }
        sameTypeMonitors.values().forEach(this::collectNetworkMonitorMetrics);
    }

    private void collectNetworkMonitorMetrics(Monitor monitor) {
        String hostname = this.telemetryManager.getHostname();
        Long strategyTime = this.telemetryManager.getStrategyTime();
        Double linkSpeed = CollectHelper.getNumberMetricValue(monitor, "hw.network.bandwidth.limit", false);
        if (linkSpeed != null && linkSpeed != 0.0) {
            Double transmittedByteRate = HwCollectHelper.calculateMetricRatePerSecond(monitor, "hw.network.io{direction=\"transmit\"}", "__hw.network.io.rate{direction=\"transmit\"}", hostname);
            Double receivedByteRate = HwCollectHelper.calculateMetricRatePerSecond(monitor, "hw.network.io{direction=\"receive\"}", "__hw.network.io.rate{direction=\"receive\"}", hostname);
            Double bandwidthUtilizationTransmitted = HwCollectHelper.isValidPositive(transmittedByteRate) ? Double.valueOf(transmittedByteRate / linkSpeed) : null;
            Double bandwidthUtilizationReceived = HwCollectHelper.isValidPositive(receivedByteRate) ? Double.valueOf(receivedByteRate / linkSpeed) : null;
            MetricFactory metricFactory = new MetricFactory(hostname);
            if (bandwidthUtilizationTransmitted != null) {
                metricFactory.collectNumberMetric(monitor, "hw.network.bandwidth.utilization{direction=\"transmit\"}", bandwidthUtilizationTransmitted, strategyTime);
            }
            if (bandwidthUtilizationReceived != null) {
                metricFactory.collectNumberMetric(monitor, "hw.network.bandwidth.utilization{direction=\"receive\"}", bandwidthUtilizationReceived, strategyTime);
            }
        }
        if (HwCollectHelper.connectorHasHardwareTag(monitor, this.telemetryManager)) {
            PowerAndEnergyCollectHelper.collectPowerAndEnergy(monitor, "hw.power{hw.type=\"network\"}", "hw.energy{hw.type=\"network\"}", this.telemetryManager, new NetworkPowerAndEnergyEstimator(monitor, this.telemetryManager));
        }
    }

    @Generated
    public static HardwareEnergyPostExecutionServiceBuilder builder() {
        return new HardwareEnergyPostExecutionServiceBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareEnergyPostExecutionService)) {
            return false;
        }
        HardwareEnergyPostExecutionService other = (HardwareEnergyPostExecutionService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        return !(this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwareEnergyPostExecutionService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HardwareEnergyPostExecutionService(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ")";
    }

    @Generated
    public HardwareEnergyPostExecutionService(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public HardwareEnergyPostExecutionService() {
    }

    @Generated
    public static class HardwareEnergyPostExecutionServiceBuilder {
        @Generated
        private TelemetryManager telemetryManager;

        @Generated
        HardwareEnergyPostExecutionServiceBuilder() {
        }

        @Generated
        public HardwareEnergyPostExecutionServiceBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public HardwareEnergyPostExecutionService build() {
            return new HardwareEnergyPostExecutionService(this.telemetryManager);
        }

        @Generated
        public String toString() {
            return "HardwareEnergyPostExecutionService.HardwareEnergyPostExecutionServiceBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ")";
        }
    }
}

