/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.delegate.IPostExecutionService;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.threshold.CpuMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.FanMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.GpuMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.LogicalDiskMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.LunMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.MemoryMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.NetworkMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.OtherDeviceMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.PhysicalDiskMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.RoboticsMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.TapeDriveMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.TemperatureMetricNormalizer;
import org.sentrysoftware.metricshub.hardware.threshold.VoltageMetricNormalizer;

public class MetricNormalizationService
implements IPostExecutionService {
    private TelemetryManager telemetryManager;
    private static final Set<KnownMonitorType> EXCLUDED_MONITOR_TYPES = Set.of(KnownMonitorType.CONNECTOR, KnownMonitorType.HOST);
    private static final Set<String> HARDWARE_MONITOR_TYPES = Stream.of(KnownMonitorType.values()).filter(type -> !EXCLUDED_MONITOR_TYPES.contains(type)).map(KnownMonitorType::getKey).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));

    private boolean isHardwareMonitor(Monitor monitor) {
        return HARDWARE_MONITOR_TYPES.contains(monitor.getType());
    }

    @Override
    public void run() {
        this.telemetryManager.getMonitors().values().stream().flatMap(monitors -> monitors.values().stream()).filter(this::isHardwareMonitor).flatMap(monitor -> KnownMonitorType.fromString(monitor.getType()).map(type -> new KnownMonitor((Monitor)monitor, (KnownMonitorType)((Object)((Object)type)))).stream()).forEach(knownMonitor -> {
            Monitor monitor = knownMonitor.getMonitor();
            String hostname = this.telemetryManager.getHostname();
            Long strategyTime = this.telemetryManager.getStrategyTime();
            switch (knownMonitor.getType()) {
                case CPU: {
                    new CpuMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case FAN: {
                    new FanMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case GPU: {
                    new GpuMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case LOGICAL_DISK: {
                    new LogicalDiskMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case LUN: {
                    new LunMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case MEMORY: {
                    new MemoryMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case NETWORK: {
                    new NetworkMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case OTHER_DEVICE: {
                    new OtherDeviceMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case PHYSICAL_DISK: {
                    new PhysicalDiskMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case ROBOTICS: {
                    new RoboticsMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case TAPE_DRIVE: {
                    new TapeDriveMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case TEMPERATURE: {
                    new TemperatureMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
                case VOLTAGE: {
                    new VoltageMetricNormalizer(strategyTime, hostname).normalize(monitor);
                    break;
                }
            }
        });
    }

    @Generated
    public static MetricNormalizationServiceBuilder builder() {
        return new MetricNormalizationServiceBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricNormalizationService)) {
            return false;
        }
        MetricNormalizationService other = (MetricNormalizationService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        return !(this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricNormalizationService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricNormalizationService(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ")";
    }

    @Generated
    public MetricNormalizationService(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public MetricNormalizationService() {
    }

    @Generated
    public static class MetricNormalizationServiceBuilder {
        @Generated
        private TelemetryManager telemetryManager;

        @Generated
        MetricNormalizationServiceBuilder() {
        }

        @Generated
        public MetricNormalizationServiceBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public MetricNormalizationService build() {
            return new MetricNormalizationService(this.telemetryManager);
        }

        @Generated
        public String toString() {
            return "MetricNormalizationService.MetricNormalizationServiceBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ")";
        }
    }

    class KnownMonitor {
        private Monitor monitor;
        private KnownMonitorType type;

        @Generated
        public Monitor getMonitor() {
            return this.monitor;
        }

        @Generated
        public KnownMonitorType getType() {
            return this.type;
        }

        @Generated
        public void setMonitor(Monitor monitor) {
            this.monitor = monitor;
        }

        @Generated
        public void setType(KnownMonitorType type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KnownMonitor)) {
                return false;
            }
            KnownMonitor other = (KnownMonitor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Monitor this$monitor = this.getMonitor();
            Monitor other$monitor = other.getMonitor();
            if (this$monitor == null ? other$monitor != null : !((Object)this$monitor).equals(other$monitor)) {
                return false;
            }
            KnownMonitorType this$type = this.getType();
            KnownMonitorType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KnownMonitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Monitor $monitor = this.getMonitor();
            result = result * 59 + ($monitor == null ? 43 : ((Object)$monitor).hashCode());
            KnownMonitorType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetricNormalizationService.KnownMonitor(monitor=" + String.valueOf(this.getMonitor()) + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }

        @Generated
        public KnownMonitor(Monitor monitor, KnownMonitorType type) {
            this.monitor = monitor;
            this.type = type;
        }
    }
}

