/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.strategy;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;

public class HardwarePostCollectStrategy
extends AbstractStrategy {
    public HardwarePostCollectStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
    }

    @Override
    public void run() {
        this.telemetryManager.getMonitors().values().stream().map(Map::values).flatMap(Collection::stream).filter(this.telemetryManager::isConnectorStatusOk).forEach(this::refreshPresentCollectTime);
    }

    private void refreshPresentCollectTime(Monitor monitor) {
        String presentMetricName = String.format("hw.status{hw.type=\"%s\", state=\"present\"}", monitor.getType());
        NumberMetric presentMetric = monitor.getMetric(presentMetricName, NumberMetric.class);
        if (presentMetric != null) {
            presentMetric.setCollectTime(this.strategyTime);
        }
    }

    @Generated
    public HardwarePostCollectStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwarePostCollectStrategy)) {
            return false;
        }
        HardwarePostCollectStrategy other = (HardwarePostCollectStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwarePostCollectStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

