/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.strategy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class HardwarePostDiscoveryStrategy
extends AbstractStrategy {
    private static final Set<String> EXCLUDED_MONITOR_TYPES = Stream.of(KnownMonitorType.HOST.getKey(), KnownMonitorType.CONNECTOR.getKey(), KnownMonitorType.LUN.getKey(), KnownMonitorType.LOGICAL_DISK.getKey(), KnownMonitorType.VOLTAGE.getKey(), KnownMonitorType.TEMPERATURE.getKey(), KnownMonitorType.VM.getKey(), KnownMonitorType.LED.getKey()).collect(Collectors.toSet());
    private static final Set<String> MONITOR_TYPE_CANDIDATES = KnownMonitorType.KEYS.stream().filter(type -> !EXCLUDED_MONITOR_TYPES.contains(type)).collect(Collectors.toSet());

    public HardwarePostDiscoveryStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
    }

    public void setAsMissing(Monitor monitor, String hostname, String metricName) {
        new MetricFactory(hostname).collectNumberMetric(monitor, metricName, 0.0, this.strategyTime);
    }

    public void setAsPresent(Monitor monitor, String hostname, String metricName) {
        new MetricFactory(hostname).collectNumberMetric(monitor, metricName, 1.0, this.strategyTime);
    }

    private boolean isCandidateMonitorType(String monitorType) {
        return MONITOR_TYPE_CANDIDATES.contains(monitorType);
    }

    @Override
    public void run() {
        this.telemetryManager.getMonitors().values().stream().map(Map::values).flatMap(Collection::stream).filter(monitor -> this.isCandidateMonitorType(monitor.getType())).filter(this.telemetryManager::isConnectorStatusOk).filter(monitor -> HwCollectHelper.connectorHasHardwareTag(monitor, this.telemetryManager)).forEach(monitor -> {
            if (!this.strategyTime.equals(monitor.getDiscoveryTime())) {
                this.setAsMissing((Monitor)monitor, this.telemetryManager.getHostname(), String.format("hw.status{hw.type=\"%s\", state=\"present\"}", monitor.getType()));
            } else {
                this.setAsPresent((Monitor)monitor, this.telemetryManager.getHostname(), String.format("hw.status{hw.type=\"%s\", state=\"present\"}", monitor.getType()));
            }
        });
    }

    @Generated
    public HardwarePostDiscoveryStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwarePostDiscoveryStrategy)) {
            return false;
        }
        HardwarePostDiscoveryStrategy other = (HardwarePostDiscoveryStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwarePostDiscoveryStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

