/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.strategy;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.strategy.IStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.HardwareEnergyPostExecutionService;
import org.sentrysoftware.metricshub.hardware.MetricNormalizationService;

public class HardwareStrategy
implements IStrategy {
    @NonNull
    private TelemetryManager telemetryManager;
    @NonNull
    private Long strategyTime;
    private static final Set<KnownMonitorType> EXCLUDED_MONITOR_TYPES = Set.of(KnownMonitorType.CONNECTOR, KnownMonitorType.HOST);
    private static final Set<String> HARDWARE_MONITOR_TYPES = Stream.of(KnownMonitorType.values()).filter(monitorType -> !EXCLUDED_MONITOR_TYPES.contains(monitorType)).map(KnownMonitorType::getKey).collect(Collectors.toSet());

    @Override
    public void run() {
        if (this.hasHardwareMonitors(this.telemetryManager)) {
            new HardwareEnergyPostExecutionService(this.telemetryManager).run();
            new MetricNormalizationService(this.telemetryManager).run();
        }
    }

    boolean hasHardwareMonitors(TelemetryManager telemetryManager) {
        return telemetryManager.getMonitors().keySet().stream().anyMatch(HARDWARE_MONITOR_TYPES::contains);
    }

    @Override
    public long getStrategyTimeout() {
        return this.telemetryManager.getHostConfiguration().getStrategyTimeout();
    }

    @Generated
    public HardwareStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
        this.strategyTime = strategyTime;
    }

    @NonNull
    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Override
    @NonNull
    @Generated
    public Long getStrategyTime() {
        return this.strategyTime;
    }

    @Generated
    public void setTelemetryManager(@NonNull TelemetryManager telemetryManager) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setStrategyTime(@NonNull Long strategyTime) {
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        this.strategyTime = strategyTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareStrategy)) {
            return false;
        }
        HardwareStrategy other = (HardwareStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$strategyTime = this.getStrategyTime();
        Long other$strategyTime = other.getStrategyTime();
        if (this$strategyTime == null ? other$strategyTime != null : !((Object)this$strategyTime).equals(other$strategyTime)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        return !(this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwareStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $strategyTime = this.getStrategyTime();
        result = result * 59 + ($strategyTime == null ? 43 : ((Object)$strategyTime).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HardwareStrategy(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", strategyTime=" + this.getStrategyTime() + ")";
    }
}

