/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class CpuPowerEstimator
extends HardwarePowerAndEnergyEstimator {
    public CpuPowerEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        super(monitor, telemetryManager);
    }

    @Override
    protected Double doPowerEstimation() {
        Double cpuSpeedLimit = CollectHelper.getNumberMetricValue(this.monitor, "hw.cpu.speed.limit{limit_type=\"max\"}", false);
        cpuSpeedLimit = cpuSpeedLimit != null && cpuSpeedLimit > 0.0 ? cpuSpeedLimit : 2.5E9;
        Double thermalDissipationRate = CollectHelper.getNumberMetricValue(this.monitor, "__hw.host.cpu.thermal_dissipation_rate", false);
        thermalDissipationRate = thermalDissipationRate != null ? thermalDissipationRate : 0.25;
        return thermalDissipationRate * (cpuSpeedLimit / 1.0E9) * 19.0;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"cpu\"}", "hw.energy{hw.type=\"cpu\"}", this.telemetryManager.getStrategyTime());
    }

    @Override
    @Generated
    public String toString() {
        return "CpuPowerEstimator()";
    }

    @Generated
    public CpuPowerEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CpuPowerEstimator)) {
            return false;
        }
        CpuPowerEstimator other = (CpuPowerEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CpuPowerEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

