/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class FanPowerAndEnergyEstimator
extends HardwarePowerAndEnergyEstimator {
    public FanPowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        super(monitor, telemetryManager);
    }

    @Override
    protected Double doPowerEstimation() {
        Double fanSpeed = CollectHelper.getNumberMetricValue(this.monitor, "hw.fan.speed", false);
        Double fanSpeedRatio = CollectHelper.getNumberMetricValue(this.monitor, "hw.fan.speed_ratio", false);
        if (HwCollectHelper.isValidPositive(fanSpeed)) {
            return fanSpeed / 1000.0;
        }
        if (HwCollectHelper.isValidRatio(fanSpeedRatio)) {
            return fanSpeedRatio * 5.0;
        }
        return 5.0;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"fan\"}", "hw.energy{hw.type=\"fan\"}", this.telemetryManager.getStrategyTime());
    }

    @Override
    @Generated
    public String toString() {
        return "FanPowerAndEnergyEstimator()";
    }

    @Generated
    public FanPowerAndEnergyEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FanPowerAndEnergyEstimator)) {
            return false;
        }
        FanPowerAndEnergyEstimator other = (FanPowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FanPowerAndEnergyEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

