/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.AbstractMetric;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostMonitorPowerAndEnergyEstimator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostMonitorPowerAndEnergyEstimator.class);
    private TelemetryManager telemetryManager;
    private Monitor hostMonitor;
    private Double powerConsumption;

    public HostMonitorPowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        this.hostMonitor = monitor;
        this.telemetryManager = telemetryManager;
    }

    public Double computeEstimatedPower() {
        this.powerConsumption = this.estimateHostPowerConsumption(this.sumEstimatedPowerConsumptions());
        return this.powerConsumption;
    }

    public Double computeMeasuredEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.hostMonitor, this.telemetryManager, this.powerConsumption, "hw.host.power{quality=\"measured\"}", "hw.host.energy{quality=\"measured\"}", this.telemetryManager.getStrategyTime());
    }

    public Double computeEstimatedEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.hostMonitor, this.telemetryManager, this.powerConsumption, "hw.host.power{quality=\"estimated\"}", "hw.host.energy{quality=\"estimated\"}", this.telemetryManager.getStrategyTime());
    }

    public Double computeMeasuredPower() {
        Map<String, Monitor> enclosureMonitors = this.telemetryManager.findMonitorsByType(KnownMonitorType.ENCLOSURE.getKey());
        Double totalMeasuredPowerConsumption = this.sumEnclosurePowerConsumptions(enclosureMonitors);
        this.adjustAllPowerConsumptions(this.sumEstimatedPowerConsumptions(), totalMeasuredPowerConsumption);
        this.powerConsumption = totalMeasuredPowerConsumption;
        return this.powerConsumption;
    }

    void adjustAllPowerConsumptions(Double totalEstimatedPowerConsumption, Double totalMeasuredPowerConsumption) {
        String hostname = this.telemetryManager.getHostname();
        if (totalEstimatedPowerConsumption == null) {
            log.debug("Hostname {} - No power consumption estimated for the monitored devices. Skip power consumption adjustment.", (Object)hostname);
            return;
        }
        Stream<Monitor> monitorStream = this.telemetryManager.getMonitors().values().stream().map(Map::values).flatMap(Collection::stream).filter(monitor -> !HwCollectHelper.isMissing(monitor)).filter(monitor -> this.telemetryManager.isConnectorStatusOk((Monitor)monitor)).filter(monitor -> !KnownMonitorType.HOST.getKey().equals(monitor.getType())).filter(monitor -> !KnownMonitorType.ENCLOSURE.getKey().equals(monitor.getType())).filter(monitor -> !KnownMonitorType.VM.getKey().equals(monitor.getType()));
        if (totalMeasuredPowerConsumption == null) {
            log.debug("Hostname {} - The measured power consumption is absent. An attempt to estimate the monitors power consumption will be made during the next collect.", (Object)hostname);
            monitorStream.forEach(monitor -> {
                Map<String, AbstractMetric> metrics = monitor.getMetrics();
                String powerMetricName = HwCollectHelper.generatePowerMetricNameForMonitorType(monitor.getType());
                String energyMetricName = HwCollectHelper.generateEnergyMetricNameForMonitorType(monitor.getType());
                metrics.remove(powerMetricName);
                metrics.remove(energyMetricName);
            });
            return;
        }
        MetricFactory metricFactory = new MetricFactory(this.telemetryManager.getHostname());
        monitorStream.forEach(monitor -> {
            String powerMetricName = HwCollectHelper.generatePowerMetricNameForMonitorType(monitor.getType());
            String energyMetricName = HwCollectHelper.generateEnergyMetricNameForMonitorType(monitor.getType());
            Double powerMetricValue = CollectHelper.getNumberMetricValue(monitor, powerMetricName, false);
            if (powerMetricValue == null) {
                return;
            }
            Double adjustedPowerValue = this.getAdjustedPowerConsumption(powerMetricValue, totalEstimatedPowerConsumption, totalMeasuredPowerConsumption);
            metricFactory.collectNumberMetric((Monitor)monitor, powerMetricName, adjustedPowerValue, this.telemetryManager.getStrategyTime());
            Double adjustedEnergyValue = HwCollectHelper.estimateEnergyUsingPower(monitor, this.telemetryManager, adjustedPowerValue, powerMetricName, energyMetricName, this.telemetryManager.getStrategyTime());
            if (adjustedEnergyValue != null) {
                metricFactory.collectNumberMetric((Monitor)monitor, energyMetricName, adjustedEnergyValue, this.telemetryManager.getStrategyTime());
            }
        });
    }

    Double getAdjustedPowerConsumption(Double estimatedPowerConsumption, Double totalEstimatedPowerConsumption, Double totalMeasuredPowerConsumption) {
        return NumberHelper.round(estimatedPowerConsumption / totalEstimatedPowerConsumption * totalMeasuredPowerConsumption, 2, RoundingMode.HALF_UP);
    }

    Double sumEnclosurePowerConsumptions(@NonNull Map<String, Monitor> enclosureMonitors) {
        if (enclosureMonitors == null) {
            throw new IllegalArgumentException("enclosureMonitors is marked non-null but is null");
        }
        String hostname = this.telemetryManager.getHostname();
        Double totalPowerConsumption = enclosureMonitors.values().stream().filter(monitor -> !HwCollectHelper.isMissing(monitor)).filter(monitor -> this.telemetryManager.isConnectorStatusOk((Monitor)monitor)).map(monitor -> CollectHelper.getUpdatedNumberMetricValue(monitor, "hw.enclosure.power")).filter(Objects::nonNull).reduce(Double::sum).orElse(null);
        if (totalPowerConsumption == null) {
            log.debug("Hostname {} - The power consumption is going to be collected during the next collect.", (Object)hostname);
            return null;
        }
        return totalPowerConsumption;
    }

    Double sumEstimatedPowerConsumptions() {
        return this.telemetryManager.getMonitors().values().stream().map(Map::values).flatMap(Collection::stream).filter(monitor -> !HwCollectHelper.isMissing(monitor)).filter(monitor -> this.telemetryManager.isConnectorStatusOk((Monitor)monitor)).filter(monitor -> !KnownMonitorType.HOST.getKey().equals(monitor.getType())).filter(monitor -> !KnownMonitorType.ENCLOSURE.getKey().equals(monitor.getType())).filter(monitor -> !KnownMonitorType.VM.getKey().equals(monitor.getType())).map(monitor -> CollectHelper.getNumberMetricValue(monitor, HwCollectHelper.generatePowerMetricNameForMonitorType(monitor.getType()), false)).filter(Objects::nonNull).reduce(Double::sum).orElse(null);
    }

    Double estimateHostPowerConsumption(Double totalEstimatedPowerConsumption) {
        String hostname = this.telemetryManager.getHostname();
        if (totalEstimatedPowerConsumption == null) {
            log.debug("Hostname {} - No power consumption estimated for the monitored devices.", (Object)hostname);
            return null;
        }
        double powerConsumptionValue = NumberHelper.round(totalEstimatedPowerConsumption / 0.9, 2, RoundingMode.HALF_UP);
        if (powerConsumptionValue > 0.0) {
            log.debug("Hostname {} - Power Consumption: Estimated at {} Watts.", (Object)hostname, (Object)powerConsumptionValue);
        } else {
            log.warn("Hostname {} - Power Consumption could not be estimated. Negative value: {}.", (Object)hostname, (Object)powerConsumptionValue);
        }
        return powerConsumptionValue;
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public Monitor getHostMonitor() {
        return this.hostMonitor;
    }

    @Generated
    public Double getPowerConsumption() {
        return this.powerConsumption;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setHostMonitor(Monitor hostMonitor) {
        this.hostMonitor = hostMonitor;
    }

    @Generated
    public void setPowerConsumption(Double powerConsumption) {
        this.powerConsumption = powerConsumption;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostMonitorPowerAndEnergyEstimator)) {
            return false;
        }
        HostMonitorPowerAndEnergyEstimator other = (HostMonitorPowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$powerConsumption = this.getPowerConsumption();
        Double other$powerConsumption = other.getPowerConsumption();
        if (this$powerConsumption == null ? other$powerConsumption != null : !((Object)this$powerConsumption).equals(other$powerConsumption)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        Monitor this$hostMonitor = this.getHostMonitor();
        Monitor other$hostMonitor = other.getHostMonitor();
        return !(this$hostMonitor == null ? other$hostMonitor != null : !((Object)this$hostMonitor).equals(other$hostMonitor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostMonitorPowerAndEnergyEstimator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $powerConsumption = this.getPowerConsumption();
        result = result * 59 + ($powerConsumption == null ? 43 : ((Object)$powerConsumption).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        Monitor $hostMonitor = this.getHostMonitor();
        result = result * 59 + ($hostMonitor == null ? 43 : ((Object)$hostMonitor).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostMonitorPowerAndEnergyEstimator(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", hostMonitor=" + String.valueOf(this.getHostMonitor()) + ", powerConsumption=" + this.getPowerConsumption() + ")";
    }
}

