/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import java.math.RoundingMode;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.ArrayHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.MathOperationsHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostMonitorThermalCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostMonitorThermalCalculator.class);
    private TelemetryManager telemetryManager;
    private static final String TEMPERATURE_METRIC = "hw.temperature";
    private static final String IS_CPU_SENSOR = "__is_cpu_sensor";
    private static final String HW_HOST_AVERAGE_CPU_TEMPERATURE = "__hw.host.average_cpu_temperature";
    private static final String HW_HOST_AMBIENT_TEMPERATURE = "hw.host.ambient_temperature";
    private static final String HW_HOST_HEATING_MARGIN = "hw.host.heating_margin";
    private static final String TEMPERATURE_WARNING_THRESHOLD = "hw.temperature.limit{limit_type=\"high.degraded\"}";
    private static final String TEMPERATURE_ALARM_THRESHOLD = "hw.temperature.limit{limit_type=\"high.critical\"}";
    private static final String HW_HOST_AVERAGE_CPU_WARNING_THRESHOLD = "__hw.host.average_warning_threshold";

    public void computeHostTemperatureMetrics() {
        Map<String, Monitor> temperatureMonitors = this.telemetryManager.findMonitorsByType(KnownMonitorType.TEMPERATURE.getKey());
        if (temperatureMonitors == null || temperatureMonitors.isEmpty()) {
            log.debug("Hostname {} - Could not compute temperature metrics ({}, {}, {})", this.telemetryManager.getHostname(), HW_HOST_AVERAGE_CPU_TEMPERATURE, "__hw.host.cpu.thermal_dissipation_rate", "__hw.host.cpu.thermal_dissipation_rate");
            return;
        }
        double ambientTemperature = 35.0;
        double cpuTemperatureAverage = 0.0;
        double cpuTemperatureCount = 0.0;
        double cpuWarningThresholdAverage = 0.0;
        double cpuWarningThresholdCount = 0.0;
        Double heatingMargin = null;
        for (Monitor temperatureMonitor : temperatureMonitors.values()) {
            Double temperatureWarningThreshold;
            Double temperature = CollectHelper.getUpdatedNumberMetricValue(temperatureMonitor, TEMPERATURE_METRIC);
            if (temperature == null) continue;
            if (temperature < ambientTemperature && temperature > 5.0) {
                ambientTemperature = temperature;
            }
            Double warningThreshold = CollectHelper.getNumberMetricValue(temperatureMonitor, TEMPERATURE_WARNING_THRESHOLD, false);
            boolean isCpuSensor = false;
            String isCpuSensorString = temperatureMonitor.getAttribute(IS_CPU_SENSOR);
            if (isCpuSensorString == null) {
                isCpuSensor = HostMonitorThermalCalculator.isCpuSensor(warningThreshold, temperatureMonitor.getAttribute("name"), temperatureMonitor.getAttribute("info"));
                temperatureMonitor.addAttribute(IS_CPU_SENSOR, String.valueOf(isCpuSensor));
            } else {
                isCpuSensor = Boolean.parseBoolean(isCpuSensorString);
            }
            if (isCpuSensor && temperature > 5.0) {
                cpuTemperatureAverage += temperature.doubleValue();
                cpuTemperatureCount += 1.0;
            }
            if ((temperatureWarningThreshold = this.getTemperatureWarningThreshold(warningThreshold, CollectHelper.getNumberMetricValue(temperatureMonitor, TEMPERATURE_ALARM_THRESHOLD, false))) == null) continue;
            heatingMargin = MathOperationsHelper.min(heatingMargin, Math.max(temperatureWarningThreshold - temperature, 0.0));
            cpuWarningThresholdAverage += temperatureWarningThreshold.doubleValue();
            cpuWarningThresholdCount += 1.0;
        }
        Monitor hostMonitor = this.telemetryManager.getEndpointHostMonitor();
        MetricFactory metricFactory = new MetricFactory(this.telemetryManager.getHostname());
        if (ambientTemperature < 35.0) {
            metricFactory.collectNumberMetric(hostMonitor, HW_HOST_AMBIENT_TEMPERATURE, ambientTemperature, this.telemetryManager.getStrategyTime());
        }
        if (cpuTemperatureCount > 0.0) {
            cpuTemperatureAverage /= cpuTemperatureCount;
            cpuTemperatureAverage = NumberHelper.round(cpuTemperatureAverage, 2, RoundingMode.HALF_UP);
            metricFactory.collectNumberMetric(hostMonitor, HW_HOST_AVERAGE_CPU_TEMPERATURE, cpuTemperatureAverage, this.telemetryManager.getStrategyTime());
            if (cpuWarningThresholdCount > 0.0) {
                cpuWarningThresholdAverage /= cpuWarningThresholdCount;
                cpuWarningThresholdAverage = NumberHelper.round(cpuWarningThresholdAverage, 2, RoundingMode.HALF_UP);
                metricFactory.collectNumberMetric(hostMonitor, HW_HOST_AVERAGE_CPU_WARNING_THRESHOLD, cpuWarningThresholdAverage, this.telemetryManager.getStrategyTime());
            }
            this.computeHostThermalDissipationRate(hostMonitor, ambientTemperature, cpuTemperatureAverage, cpuWarningThresholdAverage);
        }
        if (heatingMargin != null) {
            metricFactory.collectNumberMetric(hostMonitor, HW_HOST_HEATING_MARGIN, heatingMargin, this.telemetryManager.getStrategyTime());
        }
    }

    void computeHostThermalDissipationRate(Monitor hostMonitor, double ambientTemperature, double cpuTemperatureAverage, double cpuWarningThresholdAverage) {
        double cpuThermalDissipationRate;
        MetricFactory metricFactory = new MetricFactory(this.telemetryManager.getHostname());
        double ambientToWarningDifference = cpuWarningThresholdAverage - ambientTemperature;
        if (ambientToWarningDifference != 0.0 && (cpuThermalDissipationRate = (cpuTemperatureAverage - ambientTemperature) / ambientToWarningDifference) >= 0.0 && cpuThermalDissipationRate <= 1.0) {
            cpuThermalDissipationRate = NumberHelper.round(cpuThermalDissipationRate, 2, RoundingMode.HALF_UP);
            metricFactory.collectNumberMetric(hostMonitor, "__hw.host.cpu.thermal_dissipation_rate", cpuThermalDissipationRate, this.telemetryManager.getStrategyTime());
        }
    }

    static boolean isCpuSensor(Double warningThreshold, String ... data) {
        return warningThreshold != null && warningThreshold > 10.0 && data != null && ArrayHelper.anyMatchLowerCase(HostMonitorThermalCalculator::matchesCpuSensor, data);
    }

    static boolean matchesCpuSensor(String value) {
        return value.contains("cpu") || value.contains("proc");
    }

    private Double getTemperatureWarningThreshold(Double warningThreshold, Double alarmThreshold) {
        if (warningThreshold == null && alarmThreshold != null) {
            return NumberHelper.round(alarmThreshold * 0.9, 1, RoundingMode.HALF_UP);
        }
        return MathOperationsHelper.min(warningThreshold, alarmThreshold);
    }

    @Generated
    public static HostMonitorThermalCalculatorBuilder builder() {
        return new HostMonitorThermalCalculatorBuilder();
    }

    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Generated
    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostMonitorThermalCalculator)) {
            return false;
        }
        HostMonitorThermalCalculator other = (HostMonitorThermalCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        return !(this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostMonitorThermalCalculator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostMonitorThermalCalculator(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ")";
    }

    @Generated
    public HostMonitorThermalCalculator(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public HostMonitorThermalCalculator() {
    }

    @Generated
    public static class HostMonitorThermalCalculatorBuilder {
        @Generated
        private TelemetryManager telemetryManager;

        @Generated
        HostMonitorThermalCalculatorBuilder() {
        }

        @Generated
        public HostMonitorThermalCalculatorBuilder telemetryManager(TelemetryManager telemetryManager) {
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public HostMonitorThermalCalculator build() {
            return new HostMonitorThermalCalculator(this.telemetryManager);
        }

        @Generated
        public String toString() {
            return "HostMonitorThermalCalculator.HostMonitorThermalCalculatorBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ")";
        }
    }
}

