/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.MathOperationsHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class NetworkPowerAndEnergyEstimator
extends HardwarePowerAndEnergyEstimator {
    public NetworkPowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        super(monitor, telemetryManager);
    }

    @Override
    protected Double doPowerEstimation() {
        String name = this.monitor.getAttribute("name");
        if (name != null && (name.contains("wan") || name.contains("virt"))) {
            return 0.0;
        }
        Double linkStatus = CollectHelper.getNumberMetricValue(this.monitor, "hw.network.up", false);
        if (linkStatus != null && linkStatus == 0.0) {
            return 1.0;
        }
        Double linkSpeedMegaBit = MathOperationsHelper.divide("hw.network.bandwidth.limit", CollectHelper.getNumberMetricValue(this.monitor, "hw.network.bandwidth.limit", false), 125000.0, this.telemetryManager.getHostname());
        Double transmittedBandwidthUtilization = CollectHelper.getNumberMetricValue(this.monitor, "hw.network.bandwidth.utilization{direction=\"transmit\"}", false);
        if (HwCollectHelper.isValidRatio(transmittedBandwidthUtilization)) {
            if (HwCollectHelper.isValidPositive(linkSpeedMegaBit) && linkSpeedMegaBit > 10.0) {
                return (0.5 + 0.5 * transmittedBandwidthUtilization) * 5.0 * Math.log10(linkSpeedMegaBit);
            }
            return (0.5 + 0.5 * transmittedBandwidthUtilization) * 5.0;
        }
        if (linkSpeedMegaBit != null) {
            if (linkSpeedMegaBit > 10.0) {
                return 3.75 * Math.log10(linkSpeedMegaBit);
            }
            return 2.0;
        }
        return 10.0;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"network\"}", "hw.energy{hw.type=\"network\"}", this.telemetryManager.getStrategyTime());
    }

    @Override
    @Generated
    public String toString() {
        return "NetworkPowerAndEnergyEstimator()";
    }

    @Generated
    public NetworkPowerAndEnergyEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkPowerAndEnergyEstimator)) {
            return false;
        }
        NetworkPowerAndEnergyEstimator other = (NetworkPowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NetworkPowerAndEnergyEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

