/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import java.util.ArrayList;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.ArrayHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class PhysicalDiskPowerAndEnergyEstimator
extends HardwarePowerAndEnergyEstimator {
    public PhysicalDiskPowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        super(monitor, telemetryManager);
    }

    @Override
    protected Double doPowerEstimation() {
        String[] monitorData;
        ArrayList<String> monitorDataList = new ArrayList<String>();
        monitorDataList.add(this.monitor.getAttribute("name"));
        monitorDataList.add(this.monitor.getAttribute("model"));
        monitorDataList.add(this.monitor.getAttribute("info"));
        Monitor parentMonitor = this.telemetryManager.findParentMonitor(this.monitor);
        if (parentMonitor != null) {
            monitorDataList.add(parentMonitor.getAttribute("name"));
        }
        double powerConsumption = ArrayHelper.anyMatchLowerCase(str -> str.contains("ssd") || str.contains("solid"), monitorData = monitorDataList.toArray(new String[0])) ? this.estimateSsdPowerConsumption(monitorData) : (ArrayHelper.anyMatchLowerCase(str -> str.contains("sas"), monitorData) ? this.estimateSasPowerConsumption(monitorData) : (ArrayHelper.anyMatchLowerCase(str -> str.contains("scsi") || str.contains("ide"), monitorData) ? this.estimateScsiAndIde(monitorData) : this.estimateSataOrDefault(monitorData)));
        return powerConsumption;
    }

    double estimateSataOrDefault(String[] data) {
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("10k"), data)) {
            return 27.0;
        }
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("15k"), data)) {
            return 32.0;
        }
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("5400") || str.contains("5.4"), data)) {
            return 7.0;
        }
        return 11.0;
    }

    double estimateScsiAndIde(String[] data) {
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("10k"), data)) {
            return 32.0;
        }
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("15k"), data)) {
            return 35.0;
        }
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("5400") || str.contains("5.4"), data)) {
            return 19.0;
        }
        return 30.0;
    }

    double estimateSasPowerConsumption(String[] data) {
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("15k"), data)) {
            return 17.0;
        }
        return 12.0;
    }

    double estimateSsdPowerConsumption(String[] data) {
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("pcie"), data)) {
            return 18.0;
        }
        if (ArrayHelper.anyMatchLowerCase(str -> str.contains("nvm"), data)) {
            return 6.0;
        }
        return 3.0;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"physical_disk\"}", "hw.energy{hw.type=\"physical_disk\"}", this.telemetryManager.getStrategyTime());
    }

    @Override
    @Generated
    public String toString() {
        return "PhysicalDiskPowerAndEnergyEstimator()";
    }

    @Generated
    public PhysicalDiskPowerAndEnergyEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalDiskPowerAndEnergyEstimator)) {
            return false;
        }
        PhysicalDiskPowerAndEnergyEstimator other = (PhysicalDiskPowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PhysicalDiskPowerAndEnergyEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

