/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class RoboticsPowerAndEnergyEstimator
extends HardwarePowerAndEnergyEstimator {
    public RoboticsPowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        super(monitor, telemetryManager);
    }

    @Override
    protected Double doPowerEstimation() {
        Double moveCount = CollectHelper.getNumberMetricValue(this.monitor, "hw.robotics.moves", false);
        if (moveCount != null && moveCount > 0.0) {
            return 154.0;
        }
        return 48.0;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"robotics\"}", "hw.energy{hw.type=\"robotics\"}", this.telemetryManager.getStrategyTime());
    }

    @Override
    @Generated
    public String toString() {
        return "RoboticsPowerAndEnergyEstimator()";
    }

    @Generated
    public RoboticsPowerAndEnergyEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoboticsPowerAndEnergyEstimator)) {
            return false;
        }
        RoboticsPowerAndEnergyEstimator other = (RoboticsPowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RoboticsPowerAndEnergyEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

