/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class TapeDrivePowerAndEnergyEstimator
extends HardwarePowerAndEnergyEstimator {
    public TapeDrivePowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager) {
        super(monitor, telemetryManager);
    }

    @Override
    protected Double doPowerEstimation() {
        Double mountCount = CollectHelper.getNumberMetricValue(this.monitor, "hw.tape_drive.operations{type=\"mount\"}", false);
        mountCount = mountCount != null ? mountCount : 0.0;
        Double unmountCount = CollectHelper.getNumberMetricValue(this.monitor, "hw.tape_drive.operations{type=\"unmount\"}", false);
        unmountCount = unmountCount != null ? unmountCount : 0.0;
        boolean isActive = mountCount + unmountCount > 0.0;
        String monitorName = this.monitor.getAttribute("name");
        String lowerCaseName = monitorName == null ? "" : monitorName.toLowerCase();
        return this.estimatePowerHelper(isActive, lowerCaseName);
    }

    double estimatePowerHelper(boolean isActive, String lowerCaseName) {
        if (lowerCaseName.contains("lto")) {
            return isActive ? 46.0 : 30.0;
        }
        if (lowerCaseName.contains("t10000d")) {
            return isActive ? 127.0 : 64.0;
        }
        if (lowerCaseName.contains("t10000")) {
            return isActive ? 93.0 : 61.0;
        }
        if (lowerCaseName.contains("ts")) {
            return isActive ? 53.0 : 35.0;
        }
        return isActive ? 80.0 : 55.0;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"tape_drive\"}", "hw.energy{hw.type=\"tape_drive\"}", this.telemetryManager.getStrategyTime());
    }

    @Override
    @Generated
    public String toString() {
        return "TapeDrivePowerAndEnergyEstimator()";
    }

    @Generated
    public TapeDrivePowerAndEnergyEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TapeDrivePowerAndEnergyEstimator)) {
            return false;
        }
        TapeDrivePowerAndEnergyEstimator other = (TapeDrivePowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TapeDrivePowerAndEnergyEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

