/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.sustainability;

import java.math.RoundingMode;
import java.util.Map;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.hardware.sustainability.HardwarePowerAndEnergyEstimator;
import org.sentrysoftware.metricshub.hardware.util.HwCollectHelper;

public class VmPowerAndEnergyEstimator
extends HardwarePowerAndEnergyEstimator {
    private Map<String, Double> totalPowerSharesByPowerSource;
    private boolean isPowerMeasured;

    public VmPowerAndEnergyEstimator(Monitor monitor, TelemetryManager telemetryManager, Map<String, Double> totalPowerSharesByPowerSource, boolean isPowerMeasured) {
        super(monitor, telemetryManager);
        this.totalPowerSharesByPowerSource = totalPowerSharesByPowerSource;
        this.isPowerMeasured = isPowerMeasured;
    }

    @Override
    protected Double doPowerEstimation() {
        double vmPowerShare = HwCollectHelper.getVmPowerShare(this.monitor);
        String powerSourceId = this.monitor.getAttribute("__power_source_id");
        Double totalPowerShares = this.totalPowerSharesByPowerSource.get(powerSourceId);
        double powerShareRatio = totalPowerShares != null && totalPowerShares > 0.0 ? vmPowerShare / totalPowerShares : 0.0;
        Monitor powerSourceMonitor = this.telemetryManager.findMonitorById(powerSourceId);
        Double powerSourcePowerConsumption = null;
        if (powerSourceMonitor != null) {
            powerSourcePowerConsumption = KnownMonitorType.HOST.getKey().equals(powerSourceMonitor.getType()) ? (this.isPowerMeasured ? CollectHelper.getNumberMetricValue(powerSourceMonitor, "hw.host.power{quality=\"measured\"}", false) : CollectHelper.getNumberMetricValue(powerSourceMonitor, "hw.host.power{quality=\"estimated\"}", false)) : (KnownMonitorType.ENCLOSURE.getKey().equals(powerSourceMonitor.getType()) ? CollectHelper.getNumberMetricValue(powerSourceMonitor, "hw.enclosure.power", false) : CollectHelper.getNumberMetricValue(powerSourceMonitor, HwCollectHelper.generateEnergyMetricNameForMonitorType(powerSourceMonitor.getType()), false));
        }
        if (powerSourcePowerConsumption != null && powerSourcePowerConsumption >= 0.0) {
            this.estimatedPower = NumberHelper.round(powerSourcePowerConsumption * powerShareRatio, 2, RoundingMode.HALF_UP);
        }
        MetricFactory metricFactory = new MetricFactory(this.telemetryManager.getHostname());
        metricFactory.collectNumberMetric(this.monitor, "hw.vm.power_ratio", powerShareRatio, this.telemetryManager.getStrategyTime());
        return this.estimatedPower;
    }

    @Override
    public Double estimateEnergy() {
        return HwCollectHelper.estimateEnergyUsingPower(this.monitor, this.telemetryManager, this.estimatedPower, "hw.power{hw.type=\"vm\"}", "hw.energy{hw.type=\"vm\"}", this.telemetryManager.getStrategyTime());
    }

    @Generated
    public Map<String, Double> getTotalPowerSharesByPowerSource() {
        return this.totalPowerSharesByPowerSource;
    }

    @Generated
    public boolean isPowerMeasured() {
        return this.isPowerMeasured;
    }

    @Generated
    public void setTotalPowerSharesByPowerSource(Map<String, Double> totalPowerSharesByPowerSource) {
        this.totalPowerSharesByPowerSource = totalPowerSharesByPowerSource;
    }

    @Generated
    public void setPowerMeasured(boolean isPowerMeasured) {
        this.isPowerMeasured = isPowerMeasured;
    }

    @Override
    @Generated
    public String toString() {
        return "VmPowerAndEnergyEstimator(totalPowerSharesByPowerSource=" + String.valueOf(this.getTotalPowerSharesByPowerSource()) + ", isPowerMeasured=" + this.isPowerMeasured() + ")";
    }

    @Generated
    public VmPowerAndEnergyEstimator() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VmPowerAndEnergyEstimator)) {
            return false;
        }
        VmPowerAndEnergyEstimator other = (VmPowerAndEnergyEstimator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPowerMeasured() != other.isPowerMeasured()) {
            return false;
        }
        Map<String, Double> this$totalPowerSharesByPowerSource = this.getTotalPowerSharesByPowerSource();
        Map<String, Double> other$totalPowerSharesByPowerSource = other.getTotalPowerSharesByPowerSource();
        return !(this$totalPowerSharesByPowerSource == null ? other$totalPowerSharesByPowerSource != null : !((Object)this$totalPowerSharesByPowerSource).equals(other$totalPowerSharesByPowerSource));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VmPowerAndEnergyEstimator;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPowerMeasured() ? 79 : 97);
        Map<String, Double> $totalPowerSharesByPowerSource = this.getTotalPowerSharesByPowerSource();
        result = result * 59 + ($totalPowerSharesByPowerSource == null ? 43 : ((Object)$totalPowerSharesByPowerSource).hashCode());
        return result;
    }
}

