/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricNormalizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMetricNormalizer.class);
    protected long strategyTime;
    protected String hostname;
    private static final Pattern LIMIT_TYPE_PATTERN = Pattern.compile("limit_type *= *\"([^\"]+)\"");

    static boolean containsAllEntries(Map<String, String> firstMap, Map<String, String> secondMap) {
        return secondMap.entrySet().stream().allMatch(entry -> firstMap.containsKey(entry.getKey()) && ((String)firstMap.get(entry.getKey())).equals(entry.getValue()));
    }

    public abstract void normalize(Monitor var1);

    protected boolean isMetricCollected(Monitor monitor, String metricNamePrefix) {
        return monitor.getMetrics().values().stream().anyMatch(metric -> {
            String currentMetricNamePrefix = MetricFactory.extractName(metric.getName());
            Map<String, String> metricAttributes = metric.getAttributes();
            return metricNamePrefix.equals(currentMetricNamePrefix) && (!metricAttributes.containsKey("hw.type") || monitor.getType().equals(metricAttributes.get("hw.type"))) && metric.isUpdated();
        });
    }

    protected Optional<NumberMetric> findMetricByNamePrefixAndAttributes(@NonNull Monitor monitor, @NonNull String metricNamePrefix, @NonNull Map<String, String> metricAttributes) {
        if (monitor == null) {
            throw new IllegalArgumentException("monitor is marked non-null but is null");
        }
        if (metricNamePrefix == null) {
            throw new IllegalArgumentException("metricNamePrefix is marked non-null but is null");
        }
        if (metricAttributes == null) {
            throw new IllegalArgumentException("metricAttributes is marked non-null but is null");
        }
        AtomicInteger count = new AtomicInteger(0);
        return monitor.getMetrics().values().stream().filter(metric -> {
            boolean result;
            boolean bl = result = metric.isUpdated() && metricNamePrefix.equals(MetricFactory.extractName(metric.getName())) && AbstractMetricNormalizer.containsAllEntries(metric.getAttributes(), metricAttributes);
            if (result && count.incrementAndGet() > 1) {
                log.warn("Hostname {} - Multiple metrics found for the same prefix and attributes: {}", this.hostname, metricNamePrefix, metricAttributes);
            }
            return result;
        }).map(NumberMetric.class::cast).findFirst();
    }

    protected void normalizeErrorsLimitMetric(Monitor monitor) {
        if (!this.isMetricCollected(monitor, "hw.errors")) {
            return;
        }
        Optional<NumberMetric> maybeDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.errors.limit", Map.of("limit_type", "degraded", "hw.type", monitor.getType()));
        Optional<NumberMetric> maybeCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.errors.limit", Map.of("limit_type", "critical", "hw.type", monitor.getType()));
        if (maybeDegradedMetric.isEmpty() && maybeCriticalMetric.isEmpty()) {
            MetricFactory metricFactory = new MetricFactory(this.hostname);
            metricFactory.collectNumberMetric(monitor, String.format("hw.errors.limit{limit_type=\"critical\", hw.type=\"%s\"}", monitor.getType()), 1.0, (Long)this.strategyTime);
        } else if (maybeDegradedMetric.isPresent() && maybeCriticalMetric.isPresent()) {
            NumberMetric degradedMetric = maybeDegradedMetric.get();
            NumberMetric criticalMetric = maybeCriticalMetric.get();
            this.swapIfFirstLessThanSecond(criticalMetric, degradedMetric);
        }
    }

    protected void swapIfFirstLessThanSecond(NumberMetric firstMetric, NumberMetric secondMetric) {
        Double firstMetricValue = firstMetric.getValue();
        Double secondMetricValue = secondMetric.getValue();
        if (firstMetricValue < secondMetricValue) {
            firstMetric.setValue(secondMetricValue);
            secondMetric.setValue(firstMetricValue);
        }
    }

    protected void collectMetric(Monitor monitor, String metricName, Double value) {
        MetricFactory metricFactory = new MetricFactory(this.hostname);
        metricFactory.collectNumberMetric(monitor, metricName, value, (Long)this.strategyTime);
    }

    protected String replaceLimitType(String metricName, String newLimitType) {
        Matcher matcher = LIMIT_TYPE_PATTERN.matcher(metricName);
        return matcher.replaceAll(newLimitType);
    }

    @Generated
    public AbstractMetricNormalizer(long strategyTime, String hostname) {
        this.strategyTime = strategyTime;
        this.hostname = hostname;
    }
}

