/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class FanMetricNormalizer
extends AbstractMetricNormalizer {
    private static final Double DEFAULT_LOW_DEGRADED_VALUE_SPEED_LIMIT_METRIC = 500.0;
    private static final Double DEFAULT_LOW_CRITICAL_VALUE_SPEED_LIMIT_METRIC = 0.0;
    private static final Double DEFAULT_LOW_DEGRADED_VALUE_SPEED_RATIO_LIMIT_METRIC = 0.05;
    private static final Double DEFAULT_LOW_CRITICAL_VALUE_SPEED_RATIO_LIMIT_METRIC = 0.0;

    public FanMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeSpeedLimitMetric(monitor, "hw.fan.speed", DEFAULT_LOW_DEGRADED_VALUE_SPEED_LIMIT_METRIC, DEFAULT_LOW_CRITICAL_VALUE_SPEED_LIMIT_METRIC);
        this.normalizeSpeedLimitMetric(monitor, "hw.fan.speed_ratio", DEFAULT_LOW_DEGRADED_VALUE_SPEED_RATIO_LIMIT_METRIC, DEFAULT_LOW_CRITICAL_VALUE_SPEED_RATIO_LIMIT_METRIC);
    }

    public void normalizeSpeedLimitMetric(Monitor monitor, String metricNamePrefix, Double defaultLowDegradedValueMetric, Double defaultLowCriticalValueMetric) {
        if (!this.isMetricCollected(monitor, metricNamePrefix)) {
            return;
        }
        Optional<NumberMetric> maybeLowDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "low.degraded"));
        Optional<NumberMetric> maybeLowCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "low.critical"));
        if (maybeLowDegradedMetric.isEmpty() && maybeLowCriticalMetric.isEmpty()) {
            String lowDegradedMetricName = String.format("%s.limit{limit_type=\"%s\"}", metricNamePrefix, "low.degraded");
            String lowCriticaldMetricName = String.format("%s.limit{limit_type=\"%s\"}", metricNamePrefix, "low.critical");
            this.collectMetric(monitor, lowDegradedMetricName, defaultLowDegradedValueMetric);
            this.collectMetric(monitor, lowCriticaldMetricName, defaultLowCriticalValueMetric);
        } else if (maybeLowDegradedMetric.isPresent() && maybeLowCriticalMetric.isPresent()) {
            this.swapIfFirstLessThanSecond(maybeLowDegradedMetric.get(), maybeLowCriticalMetric.get());
        } else if (maybeLowDegradedMetric.isEmpty()) {
            NumberMetric lowCriticalMetric = maybeLowCriticalMetric.get();
            String lowDegradedMetricName = this.replaceLimitType(lowCriticalMetric.getName(), "limit_type=\"low.degraded\"");
            this.collectMetric(monitor, lowDegradedMetricName, lowCriticalMetric.getValue() * 1.1);
        } else {
            NumberMetric lowDegradedMetric = maybeLowDegradedMetric.get();
            String lowCriticalMetricName = this.replaceLimitType(lowDegradedMetric.getName(), "limit_type=\"low.critical\"");
            this.collectMetric(monitor, lowCriticalMetricName, lowDegradedMetric.getValue() * 0.9);
        }
    }
}

