/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class GpuMetricNormalizer
extends AbstractMetricNormalizer {
    public GpuMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    protected void normalizeGpuLimitMetric(Monitor monitor, String metricNamePrefix, double defaultCriticalValue, double defaultDegradedValue) {
        String metricNamePrefixWithLimit = metricNamePrefix + ".limit";
        if (!this.isMetricCollected(monitor, metricNamePrefix)) {
            return;
        }
        Optional<NumberMetric> maybeDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, metricNamePrefixWithLimit, Map.of("limit_type", "degraded"));
        Optional<NumberMetric> maybeCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, metricNamePrefixWithLimit, Map.of("limit_type", "critical"));
        if (maybeDegradedMetric.isEmpty() && maybeCriticalMetric.isEmpty()) {
            this.collectMetric(monitor, metricNamePrefixWithLimit + "{limit_type=\"critical\"}", defaultCriticalValue);
            this.collectMetric(monitor, metricNamePrefixWithLimit + "{limit_type=\"degraded\"}", defaultDegradedValue);
        } else if (maybeDegradedMetric.isPresent() && maybeCriticalMetric.isPresent()) {
            this.swapIfFirstLessThanSecond(maybeCriticalMetric.get(), maybeDegradedMetric.get());
        } else if (maybeDegradedMetric.isEmpty()) {
            NumberMetric criticalMetric = maybeCriticalMetric.get();
            String degradedMetricName = this.replaceLimitType(criticalMetric.getName(), "limit_type=\"degraded\"");
            this.collectMetric(monitor, degradedMetricName, maybeCriticalMetric.get().getValue() * 0.9);
        } else {
            NumberMetric degradedMetric = maybeDegradedMetric.get();
            String criticalMetricName = this.replaceLimitType(degradedMetric.getName(), "limit_type=\"critical\"");
            this.collectMetric(monitor, criticalMetricName, 100.0 - (100.0 - maybeDegradedMetric.get().getValue()) * 0.5);
        }
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeErrorsLimitMetric(monitor);
        this.normalizeGpuLimitMetric(monitor, "hw.gpu.memory.utilization", 0.95, 0.9);
        this.normalizeGpuLimitMetric(monitor, "hw.gpu.utilization", 0.9, 0.8);
    }
}

