/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class LunMetricNormalizer
extends AbstractMetricNormalizer {
    public LunMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    private void normalizeLunPathsLimit(Monitor monitor) {
        Optional<NumberMetric> maybeAvailableMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.lun.paths", Map.of("type", "available"));
        if (maybeAvailableMetric.isEmpty()) {
            return;
        }
        Optional<NumberMetric> maybeExpectedMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.lun.paths", Map.of("type", "expected"));
        Optional<NumberMetric> maybeLowDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.lun.paths.limit", Map.of("limit_type", "low.degraded"));
        Optional<NumberMetric> maybeMaximumMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.lun.paths.limit", Map.of("limit_type", "maximum"));
        Double available = maybeAvailableMetric.get().getValue();
        if (available > 1.0 && (maybeLowDegradedMetric.isEmpty() || maybeMaximumMetric.isPresent() && available > maybeMaximumMetric.get().getValue())) {
            this.collectLowDegradedMetric(monitor, available - 1.0);
        }
        if (maybeExpectedMetric.isEmpty()) {
            this.collectMetric(monitor, "hw.lun.paths{type=\"expected\"}", available + 1.0);
        }
    }

    private void collectLowDegradedMetric(Monitor monitor, Double newValue) {
        this.collectMetric(monitor, "hw.lun.paths.limit{limit_type=\"low.degraded\"}", newValue);
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeLunPathsLimit(monitor);
    }
}

