/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class NetworkMetricNormalizer
extends AbstractMetricNormalizer {
    public NetworkMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    private void normalizeNetworkErrorRatioMetric(Monitor monitor) {
        if (!this.isMetricCollected(monitor, "hw.network.error_ratio")) {
            return;
        }
        Optional<NumberMetric> maybeDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.network.error_ratio.limit", Map.of("limit_type", "degraded", "hw.type", monitor.getType()));
        Optional<NumberMetric> maybeCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, "hw.network.error_ratio.limit", Map.of("limit_type", "critical", "hw.type", monitor.getType()));
        if (maybeCriticalMetric.isEmpty() && maybeDegradedMetric.isEmpty()) {
            this.collectMetric(monitor, "hw.network.error_ratio.limit{limit_type=\"degraded\", hw.type=\"network\"}", 0.2);
            this.collectMetric(monitor, "hw.network.error_ratio.limit{limit_type=\"critical\", hw.type=\"network\"}", 0.3);
        } else if (maybeCriticalMetric.isPresent() && maybeDegradedMetric.isPresent()) {
            this.swapIfFirstLessThanSecond(maybeCriticalMetric.get(), maybeDegradedMetric.get());
        }
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeNetworkErrorRatioMetric(monitor);
    }
}

