/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class OtherDeviceMetricNormalizer
extends AbstractMetricNormalizer {
    public OtherDeviceMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeOtherDeviceLimitMetric(monitor, "hw.other_device.uses");
        this.normalizeOtherDeviceLimitMetric(monitor, "hw.other_device.value");
    }

    private void normalizeOtherDeviceLimitMetric(Monitor monitor, String metricNamePrefix) {
        if (!this.isMetricCollected(monitor, metricNamePrefix)) {
            return;
        }
        Optional<NumberMetric> maybeDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "degraded"));
        Optional<NumberMetric> maybeCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "critical"));
        if (maybeDegradedMetric.isPresent() && maybeCriticalMetric.isPresent()) {
            this.swapIfFirstLessThanSecond(maybeDegradedMetric.get(), maybeCriticalMetric.get());
        } else if (maybeCriticalMetric.isPresent()) {
            NumberMetric criticalMetric = maybeCriticalMetric.get();
            String degradedMetricName = this.replaceLimitType(criticalMetric.getName(), "limit_type=\"degraded\"");
            this.collectMetric(monitor, degradedMetricName, criticalMetric.getValue() * 0.9);
        } else if (maybeDegradedMetric.isPresent()) {
            NumberMetric degradedMetric = maybeDegradedMetric.get();
            String criticalMetricName = this.replaceLimitType(degradedMetric.getName(), "limit_type=\"critical\"");
            this.collectMetric(monitor, criticalMetricName, degradedMetric.getValue() * 1.1);
        }
    }
}

