/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class TemperatureMetricNormalizer
extends AbstractMetricNormalizer {
    public TemperatureMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeTemperatureLimitMetric(monitor, "hw.temperature");
    }

    private void normalizeTemperatureLimitMetric(Monitor monitor, String metricNamePrefix) {
        if (!this.isMetricCollected(monitor, metricNamePrefix)) {
            return;
        }
        Optional<NumberMetric> maybeHighDegradedMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "high.degraded"));
        Optional<NumberMetric> maybeHighCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "high.critical"));
        if (maybeHighDegradedMetric.isPresent() && maybeHighCriticalMetric.isPresent()) {
            this.swapIfFirstLessThanSecond(maybeHighCriticalMetric.get(), maybeHighDegradedMetric.get());
        } else if (maybeHighCriticalMetric.isPresent()) {
            NumberMetric highCriticalMetric = maybeHighCriticalMetric.get();
            String highDegradedMetricName = this.replaceLimitType(highCriticalMetric.getName(), "limit_type=\"high.degraded\"");
            this.collectMetric(monitor, highDegradedMetricName, highCriticalMetric.getValue() * 0.9);
        } else if (maybeHighDegradedMetric.isPresent()) {
            NumberMetric highDegradedMetric = maybeHighDegradedMetric.get();
            String highCriticaldMetricName = this.replaceLimitType(highDegradedMetric.getName(), "limit_type=\"high.critical\"");
            this.collectMetric(monitor, highCriticaldMetricName, highDegradedMetric.getValue() * 1.1);
        }
    }
}

