/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.threshold;

import java.util.Map;
import java.util.Optional;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.sentrysoftware.metricshub.hardware.threshold.AbstractMetricNormalizer;

public class VoltageMetricNormalizer
extends AbstractMetricNormalizer {
    public VoltageMetricNormalizer(long strategyTime, String hostname) {
        super(strategyTime, hostname);
    }

    @Override
    public void normalize(Monitor monitor) {
        this.normalizeVoltageLimitMetric(monitor, "hw.voltage");
    }

    private void normalizeVoltageLimitMetric(Monitor monitor, String metricNamePrefix) {
        if (!this.isMetricCollected(monitor, metricNamePrefix)) {
            return;
        }
        Optional<NumberMetric> maybeHighCriticaldMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "high.critical"));
        Optional<NumberMetric> maybeLowCriticalMetric = this.findMetricByNamePrefixAndAttributes(monitor, String.format("%s.limit", metricNamePrefix), Map.of("limit_type", "low.critical"));
        if (maybeHighCriticaldMetric.isPresent() && maybeLowCriticalMetric.isPresent()) {
            this.swapIfFirstLessThanSecond(maybeHighCriticaldMetric.get(), maybeLowCriticalMetric.get());
        } else if (maybeHighCriticaldMetric.isPresent()) {
            Double maybeHighCriticalMetricValue;
            NumberMetric highCriticalMetric = maybeHighCriticaldMetric.get();
            Double maybeLowCriticalMetricValue = highCriticalMetric.getValue();
            String lowCriticalMetricName = this.replaceLimitType(highCriticalMetric.getName(), "limit_type=\"low.critical\"");
            Double lowCriticalMetricValue = maybeLowCriticalMetricValue;
            Double highCriticalMetricValue = maybeHighCriticalMetricValue = Double.valueOf(maybeLowCriticalMetricValue * 1.1);
            if (lowCriticalMetricValue <= 0.0) {
                highCriticalMetricValue = maybeLowCriticalMetricValue;
                lowCriticalMetricValue = maybeHighCriticalMetricValue;
            }
            highCriticalMetric.setValue(highCriticalMetricValue);
            this.collectMetric(monitor, lowCriticalMetricName, lowCriticalMetricValue);
        } else if (maybeLowCriticalMetric.isPresent()) {
            Double maybeLowCriticalMetricValue;
            NumberMetric lowCriticalMetric = maybeLowCriticalMetric.get();
            Double maybeHighCriticalMetricValue = lowCriticalMetric.getValue();
            String highCriticalMetricName = this.replaceLimitType(lowCriticalMetric.getName(), "limit_type=\"high.critical\"");
            Double highCriticalMetricValue = maybeHighCriticalMetricValue;
            Double lowCriticalMetricValue = maybeLowCriticalMetricValue = Double.valueOf(maybeHighCriticalMetricValue * 0.9);
            if (highCriticalMetricValue <= 0.0) {
                highCriticalMetricValue = maybeLowCriticalMetricValue;
                lowCriticalMetricValue = maybeHighCriticalMetricValue;
            }
            lowCriticalMetric.setValue(lowCriticalMetricValue);
            this.collectMetric(monitor, highCriticalMetricName, highCriticalMetricValue);
        }
    }
}

