/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.hardware.util;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectorIdentity;
import org.sentrysoftware.metricshub.engine.connector.model.identity.Detection;
import org.sentrysoftware.metricshub.engine.strategy.utils.CollectHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.MathOperationsHelper;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.engine.telemetry.metric.NumberMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HwCollectHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HwCollectHelper.class);

    public static boolean isValidPositive(Double value) {
        return value != null && value >= 0.0;
    }

    public static boolean isValidRatio(Double ratio) {
        return ratio != null && ratio >= 0.0 && ratio <= 1.0;
    }

    public static Double estimateEnergyUsingPower(Monitor monitor, TelemetryManager telemetryManager, Double estimatedPower, String powerMetricName, String energyMetricName, Long collectTime) {
        String hostname = telemetryManager.getHostname();
        Double collectTimePrevious = CollectHelper.getNumberMetricCollectTime(monitor, powerMetricName, true);
        Double deltaTimeMs = MathOperationsHelper.subtract(powerMetricName, (double)collectTime, collectTimePrevious, hostname);
        Double deltaTime = deltaTimeMs != null ? Double.valueOf(deltaTimeMs / 1000.0) : null;
        Double energyUsage = MathOperationsHelper.multiply(powerMetricName, estimatedPower, deltaTime, hostname);
        if (energyUsage != null) {
            Double energy = energyUsage;
            Double previousEnergy = CollectHelper.getNumberMetricValue(monitor, energyMetricName, true);
            if (previousEnergy != null) {
                energy = energy + previousEnergy;
            }
            return energy;
        }
        log.debug("Hostname {} - Cannot calculate energy {} for monitor {}. Current raw value {} - Current time {} - Previous time {}.", hostname, energyMetricName, monitor.getId(), estimatedPower, collectTime, collectTimePrevious);
        return null;
    }

    public static Double calculateMetricRatePerSecond(Monitor monitor, String counterMetricName, String rateMetricName, String hostname) {
        Double value = CollectHelper.getNumberMetricValue(monitor, counterMetricName, false);
        Double previousValue = CollectHelper.getNumberMetricValue(monitor, counterMetricName, true);
        Double collectTime = CollectHelper.getNumberMetricCollectTime(monitor, counterMetricName, false);
        Double previousCollectTime = CollectHelper.getNumberMetricCollectTime(monitor, counterMetricName, true);
        return Optional.ofNullable(MathOperationsHelper.rate(rateMetricName, value, previousValue, collectTime, previousCollectTime, hostname)).map(rate -> rate * 1000.0).orElse(null);
    }

    public static String generatePowerMetricNameForMonitorType(String monitorType) {
        return "hw.power{hw.type=\"" + monitorType + "\"}";
    }

    public static String generateEnergyMetricNameForMonitorType(String monitorType) {
        return "hw.energy{hw.type=\"" + monitorType + "\"}";
    }

    public static Double getVmPowerShare(Monitor vm) {
        if (!HwCollectHelper.isVmOnline(vm)) {
            return 0.0;
        }
        Double powerShare = CollectHelper.getNumberMetricValue(vm, "__hw.vm.power_ratio.raw_power_share", false);
        if (powerShare != null && powerShare >= 0.0) {
            return powerShare;
        }
        return 0.0;
    }

    private static boolean isVmOnline(Monitor vm) {
        return "on".equals(CollectHelper.getStateSetMetricValue(vm, "hw.power_state{hw.type=\"vm\"}", false));
    }

    static boolean hasPresentMetric(Monitor monitor) {
        return monitor.getMetrics().containsKey(String.format("hw.status{hw.type=\"%s\", state=\"present\"}", monitor.getType()));
    }

    public static boolean isMissing(Monitor monitor) {
        if (!HwCollectHelper.hasPresentMetric(monitor)) {
            return false;
        }
        NumberMetric presentMetric = monitor.getMetric(String.format("hw.status{hw.type=\"%s\", state=\"present\"}", monitor.getType()), NumberMetric.class);
        Double present = presentMetric != null ? presentMetric.getValue() : null;
        return Double.valueOf(0.0).equals(present);
    }

    public static boolean connectorHasHardwareTag(Monitor monitor, TelemetryManager telemetryManager) {
        if (monitor == null) {
            return false;
        }
        ConnectorStore telemetryManagerConnectorStore = telemetryManager.getConnectorStore();
        if (telemetryManagerConnectorStore == null) {
            log.error("Hostname {} - ConnectorStore does not exist.", (Object)telemetryManager.getHostname());
            return false;
        }
        Map<String, Connector> store = telemetryManagerConnectorStore.getStore();
        if (store == null) {
            log.error("Hostname {} - ConnectorStore store does not exist.", (Object)telemetryManager.getHostname());
            return false;
        }
        String connectorId = monitor.getAttribute("connector_id");
        if (connectorId == null) {
            log.error("Hostname {} - Monitor {} connector_id attribute does not exist.", (Object)telemetryManager.getHostname(), (Object)monitor.getId());
            return false;
        }
        Connector connector = store.get(connectorId);
        if (connector == null) {
            log.error("Hostname {} - Monitor {} connector_id attribute does not correspond to any valid connector id.", (Object)telemetryManager.getHostname(), (Object)monitor.getId());
            return false;
        }
        ConnectorIdentity connectorIdentity = connector.getConnectorIdentity();
        Detection detection = connectorIdentity != null ? connectorIdentity.getDetection() : null;
        Set<String> connectorTags = detection != null ? detection.getTags() : null;
        return connectorTags != null && connectorTags.stream().anyMatch(tag -> tag.equalsIgnoreCase("hardware"));
    }

    @Generated
    private HwCollectHelper() {
    }
}

